/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph;

import com.github.ferstl.depgraph.graph.Edge;
import com.github.ferstl.depgraph.graph.EdgeRenderer;
import com.github.ferstl.depgraph.graph.GraphFormatter;
import com.github.ferstl.depgraph.graph.Node;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.github.ferstl.depgraph.graph.dot.DotAttributeBuilder;
import com.github.ferstl.depgraph.graph.dot.DotGraphFormatter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class GraphBuilder<T> {
    private String graphName;
    private GraphFormatter graphFormatter;
    private NodeRenderer<? super T> nodeIdRenderer;
    private NodeRenderer<? super T> nodeNameRenderer;
    private EdgeRenderer<? super T> edgeRenderer;
    private boolean omitSelfReferences;
    private final Map<String, Node<T>> nodeDefinitions;
    private final Set<Edge> edges;

    public static <T> GraphBuilder<T> create() {
        return new GraphBuilder<T>();
    }

    public GraphBuilder() {
        DotAttributeBuilder graphAttributeBuilder = new DotAttributeBuilder();
        DotAttributeBuilder nodeAttributeBuilder = new DotAttributeBuilder().shape("box").fontName("Helvetica");
        DotAttributeBuilder edgeAttributeBuilder = new DotAttributeBuilder().fontName("Helvetica").fontSize(10);
        this.graphName = "G";
        this.graphFormatter = new DotGraphFormatter(graphAttributeBuilder, nodeAttributeBuilder, edgeAttributeBuilder);
        this.nodeIdRenderer = GraphBuilder.createDefaultNodeIdRenderer();
        this.nodeNameRenderer = GraphBuilder.createDefaultNodeNameRenderer();
        this.edgeRenderer = GraphBuilder.createDefaultEdgeRenderer();
        this.nodeDefinitions = new LinkedHashMap<String, Node<T>>();
        this.edges = new LinkedHashSet<Edge>();
    }

    public GraphBuilder<T> graphName(String name) {
        this.graphName = name;
        return this;
    }

    public GraphBuilder<T> useNodeIdRenderer(NodeRenderer<? super T> nodeIdRenderer) {
        this.nodeIdRenderer = nodeIdRenderer;
        return this;
    }

    public GraphBuilder<T> useNodeNameRenderer(NodeRenderer<? super T> nodeNameRenderer) {
        this.nodeNameRenderer = nodeNameRenderer;
        return this;
    }

    public GraphBuilder<T> useEdgeRenderer(EdgeRenderer<? super T> edgeRenderer) {
        this.edgeRenderer = edgeRenderer;
        return this;
    }

    public GraphBuilder<T> omitSelfReferences() {
        this.omitSelfReferences = true;
        return this;
    }

    public GraphBuilder<T> graphFormatter(GraphFormatter formatter) {
        this.graphFormatter = formatter;
        return this;
    }

    public boolean isEmpty() {
        return this.nodeDefinitions.isEmpty();
    }

    public GraphBuilder<T> addNode(T node) {
        String nodeId = this.nodeIdRenderer.render(node);
        String nodeName = this.nodeNameRenderer.render(node);
        this.nodeDefinitions.put(nodeId, new Node<T>(nodeId, nodeName, node));
        return this;
    }

    public GraphBuilder<T> addEdge(T from, T to) {
        if (from != null && to != null) {
            this.addNode(from);
            this.addNode(to);
            this.safelyAddEdge(from, to);
        }
        return this;
    }

    public T getEffectiveNode(T node) {
        String key = this.nodeIdRenderer.render(node);
        if (this.nodeDefinitions.containsKey(key)) {
            return this.nodeDefinitions.get((Object)key).nodeObject;
        }
        return node;
    }

    public String toString() {
        ImmutableList.Builder nodeListBuilder = ImmutableList.builder();
        for (Node<T> node : this.nodeDefinitions.values()) {
            nodeListBuilder.add(node);
        }
        ImmutableList nodeList = nodeListBuilder.build();
        ImmutableSet edgeSet = ImmutableSet.copyOf(this.edges);
        return this.graphFormatter.format(this.graphName, (Collection<Node<?>>)nodeList, (Collection<Edge>)edgeSet);
    }

    private void safelyAddEdge(T fromNode, T toNode) {
        String fromNodeId = this.nodeIdRenderer.render(fromNode);
        String toNodeId = this.nodeIdRenderer.render(toNode);
        if (!this.omitSelfReferences || !fromNodeId.equals(toNodeId)) {
            Edge edge = new Edge(fromNodeId, toNodeId, this.edgeRenderer.render(fromNode, toNode));
            this.edges.add(edge);
        }
    }

    private static <T> EdgeRenderer<T> createDefaultEdgeRenderer() {
        return new EdgeRenderer<T>(){

            @Override
            public String render(T from, T to) {
                return "";
            }
        };
    }

    private static <T> NodeRenderer<T> createDefaultNodeIdRenderer() {
        return new NodeRenderer<T>(){

            @Override
            public String render(T node) {
                return node.toString();
            }
        };
    }

    private static <T> NodeRenderer<T> createDefaultNodeNameRenderer() {
        return new NodeRenderer<T>(){

            @Override
            public String render(T node) {
                return "";
            }
        };
    }
}

