/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.AbstractAggregatingGraphMojo;
import com.github.ferstl.depgraph.dependency.AggregatingGraphFactory;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.DependencyNodeIdRenderer;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.MavenGraphAdapter;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="aggregate", aggregator=true, defaultPhase=LifecyclePhase.NONE, inheritByDefault=false, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class AggregatingDependencyGraphMojo
extends AbstractAggregatingGraphMojo {
    @Parameter(property="showGroupIds", defaultValue="false")
    private boolean showGroupIds;
    @Parameter(property="showVersions", defaultValue="false")
    private boolean showVersions;
    @Parameter(property="showTypes", defaultValue="false")
    private boolean showTypes;
    @Parameter(property="showClassifiers", defaultValue="false")
    private boolean showClassifiers;
    @Parameter(property="includeParentProjects", defaultValue="false")
    private boolean includeParentProjects;
    @Parameter(property="mergeTypes", defaultValue="false")
    private boolean mergeTypes;
    @Parameter(property="mergeClassifiers", defaultValue="false")
    private boolean mergeClassifiers;

    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, GraphStyleConfigurer graphStyleConfigurer) {
        this.handleOptionsForFullGraph();
        DependencyNodeIdRenderer nodeIdRenderer = DependencyNodeIdRenderer.versionlessId().withClassifier(!this.mergeClassifiers).withType(!this.mergeTypes).withScope(!this.mergeScopes);
        GraphBuilder<DependencyNode> graphBuilder = graphStyleConfigurer.showGroupIds(this.showGroupIds).showArtifactIds(true).showTypes(this.showTypes).showClassifiers(this.showClassifiers).showVersionsOnNodes(this.showVersions).showVersionsOnEdges(false).repeatTransitiveDependencies(this.repeatTransitiveDependenciesInTextGraph).configure(GraphBuilder.create(nodeIdRenderer));
        MavenGraphAdapter adapter = new MavenGraphAdapter(this.dependencyGraphBuilder, transitiveIncludeExcludeFilter, targetFilter, this.reduceEdges);
        return new AggregatingGraphFactory(adapter, this.createReactorOrderSubProjectSupplier(), globalFilter, graphBuilder, this.includeParentProjects);
    }

    private void handleOptionsForFullGraph() {
        if (this.showFullGraph()) {
            this.showGroupIds = true;
            this.showVersions = true;
            this.showTypes = true;
            this.showClassifiers = true;
        }
    }
}

