/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyGraphMojo;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="example", aggregator=true, defaultPhase=LifecyclePhase.NONE, requiresDependencyCollection=ResolutionScope.NONE, threadSafe=true)
public class ExampleGraphMojo
extends DependencyGraphMojo {
    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, GraphStyleConfigurer graphStyleConfigurer) {
        GraphBuilder<DependencyNode> graphBuilder = this.createGraphBuilder(graphStyleConfigurer);
        return new ExampleGraphFactory(graphBuilder, globalFilter, targetFilter);
    }

    static class ExampleGraphFactory
    implements GraphFactory {
        private final GraphBuilder<DependencyNode> graphBuilder;
        private final ArtifactFilter globalFilter;
        private final ArtifactFilter targetFilter;

        ExampleGraphFactory(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter globalFilter, ArtifactFilter targetFilter) {
            this.graphBuilder = graphBuilder;
            this.globalFilter = globalFilter;
            this.targetFilter = targetFilter;
        }

        @Override
        public String createGraph(MavenProject project) {
            DefaultArtifact aA = new DefaultArtifact("com.example", "artifact-a", "1.0.0", "compile", "jar", "", null);
            DefaultArtifact aB = new DefaultArtifact("com.example", "artifact-b", "1.0.0", "compile", "jar", "", null);
            DefaultArtifact aC = new DefaultArtifact("com.example", "artifact-c", "2.0.0", "compile", "jar", "", null);
            DefaultArtifact aCV1 = new DefaultArtifact("com.example", "artifact-c", "1.0.0", "compile", "jar", "", null);
            DefaultArtifact aD = new DefaultArtifact("com.example", "artifact-d", "1.0.0", "compile", "jar", "", null);
            DefaultArtifact aE = new DefaultArtifact("com.example.sub", "artifact-e", "1.0.0", "provided", "jar", "", null);
            DefaultArtifact aF = new DefaultArtifact("com.example.sub", "artifact-f", "1.0.0", "runtime", "jar", "", null);
            DefaultArtifact aG = new DefaultArtifact("com.example.sub", "artifact-g", "1.0.0", "test", "jar", "", null);
            DefaultArtifact aZ = new DefaultArtifact("com.example.sub", "artifact-zip", "1.0.0", "compile", "zip", "", null);
            DependencyNode nA = new DependencyNode((Artifact)aA);
            DependencyNode nB = new DependencyNode((Artifact)aB);
            DependencyNode nC = new DependencyNode((Artifact)aC);
            DependencyNode nCDup = new DependencyNode(new org.apache.maven.shared.dependency.tree.DependencyNode((Artifact)aC, 1, (Artifact)aC));
            DependencyNode nCConfl = new DependencyNode(new org.apache.maven.shared.dependency.tree.DependencyNode((Artifact)aCV1, 2, (Artifact)aCV1));
            DependencyNode nD = new DependencyNode((Artifact)aD);
            DependencyNode nE = new DependencyNode((Artifact)aE);
            DependencyNode nF = new DependencyNode((Artifact)aF);
            DependencyNode nG = new DependencyNode((Artifact)aG);
            DependencyNode nZ = new DependencyNode((Artifact)aZ);
            this.addEdge(nA, nB);
            this.addEdge(nA, nD);
            this.addEdge(nG, nCConfl);
            this.addEdge(nB, nC);
            this.addEdge(nB, nD);
            this.addEdge(nZ, nCDup);
            this.addEdge(nD, nE);
            this.addEdge(nD, nF);
            this.addEdge(nB, nG);
            this.addEdge(nB, nZ);
            return this.graphBuilder.toString();
        }

        private void addEdge(DependencyNode from, DependencyNode to) {
            if (this.globalFilter.include(from.getArtifact()) && this.globalFilter.include(to.getArtifact()) && this.targetFilter.include(to.getArtifact())) {
                this.graphBuilder.addEdge(from, to);
            }
        }
    }
}

