/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

class GraphBuildingVisitor
implements DependencyNodeVisitor,
org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor {
    private final GraphBuilder<DependencyNode> graphBuilder;
    private final boolean omitReachablePaths;
    private final Deque<DependencyNode> nodeStack;
    private final ArtifactFilter globalFilter;
    private final ArtifactFilter transitiveFilter;
    private final ArtifactFilter targetFilter;
    private final Set<NodeResolution> includedResolutions;
    private int cutOffDepth = 0;

    GraphBuildingVisitor(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter globalFilter, ArtifactFilter transitiveFilter, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions) {
        this(graphBuilder, globalFilter, transitiveFilter, targetFilter, includedResolutions, false);
    }

    GraphBuildingVisitor(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter transitiveFilter, ArtifactFilter targetFilter, boolean omitReachablePaths) {
        this(graphBuilder, DoNothingArtifactFilter.INSTANCE, transitiveFilter, targetFilter, EnumSet.allOf(NodeResolution.class), omitReachablePaths);
    }

    private GraphBuildingVisitor(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter globalFilter, ArtifactFilter transitiveFilter, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions, boolean omitReachablePaths) {
        this.graphBuilder = graphBuilder;
        this.omitReachablePaths = omitReachablePaths;
        this.nodeStack = new ArrayDeque<DependencyNode>();
        this.globalFilter = globalFilter;
        this.transitiveFilter = transitiveFilter;
        this.targetFilter = targetFilter;
        this.includedResolutions = includedResolutions;
    }

    public boolean visit(org.apache.maven.shared.dependency.graph.DependencyNode node) {
        return this.internalVisit(new DependencyNode(node));
    }

    public boolean endVisit(org.apache.maven.shared.dependency.graph.DependencyNode node) {
        return this.internalEndVisit(new DependencyNode(node));
    }

    public boolean visit(org.apache.maven.shared.dependency.tree.DependencyNode node) {
        return this.internalVisit(new DependencyNode(node));
    }

    public boolean endVisit(org.apache.maven.shared.dependency.tree.DependencyNode node) {
        return this.internalEndVisit(new DependencyNode(node));
    }

    private boolean internalVisit(DependencyNode node) {
        if (this.isExcluded(node)) {
            return false;
        }
        this.nodeStack.push(node);
        if (this.targetFilter.include(node.getArtifact())) {
            this.cutOffDepth = this.nodeStack.size();
        }
        return true;
    }

    private boolean internalEndVisit(DependencyNode node) {
        if (this.isExcluded(node)) {
            return true;
        }
        this.nodeStack.pop();
        DependencyNode currentParent = this.nodeStack.peek();
        if (this.nodeStack.size() < this.cutOffDepth) {
            this.cutOffDepth = this.nodeStack.size();
            if (currentParent != null) {
                this.mergeWithExisting(node);
                if (!this.omitReachablePaths || !this.graphBuilder.isReachable(node, currentParent) || "test".equals(node.getArtifact().getScope())) {
                    this.graphBuilder.addEdge(currentParent, node);
                } else {
                    this.graphBuilder.addNode(node);
                }
            }
        }
        return true;
    }

    private boolean isExcluded(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        return !this.globalFilter.include(artifact) || !this.transitiveFilter.include(artifact) || !this.includedResolutions.contains((Object)node.getResolution());
    }

    private void mergeWithExisting(DependencyNode node) {
        DependencyNode effectiveNode = this.graphBuilder.getEffectiveNode(node);
        node.merge(effectiveNode);
    }

    private static enum DoNothingArtifactFilter implements ArtifactFilter
    {
        INSTANCE;


        public boolean include(Artifact artifact) {
            return true;
        }
    }
}

