/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyGraphException;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphBuildingVisitor;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.OrArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public final class MavenGraphAdapter {
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final DependencyTreeBuilder dependencyTreeBuilder;
    private final ArtifactRepository artifactRepository;
    private final ArtifactFilter transitiveIncludeExcludeFilter;
    private final ArtifactFilter targetFilter;
    private final boolean omitReachablePaths;
    private final Set<NodeResolution> includedResolutions;

    public MavenGraphAdapter(DependencyGraphBuilder builder, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, boolean omitReachablePaths) {
        this.dependencyGraphBuilder = builder;
        this.transitiveIncludeExcludeFilter = transitiveIncludeExcludeFilter;
        this.targetFilter = targetFilter;
        this.omitReachablePaths = omitReachablePaths;
        this.includedResolutions = EnumSet.allOf(NodeResolution.class);
        this.dependencyTreeBuilder = null;
        this.artifactRepository = null;
    }

    public MavenGraphAdapter(DependencyTreeBuilder builder, ArtifactRepository artifactRepository, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions) {
        this.dependencyTreeBuilder = builder;
        this.artifactRepository = artifactRepository;
        this.transitiveIncludeExcludeFilter = transitiveIncludeExcludeFilter;
        this.targetFilter = targetFilter;
        this.omitReachablePaths = false;
        this.includedResolutions = includedResolutions;
        this.dependencyGraphBuilder = null;
    }

    public void buildDependencyGraph(MavenProject project, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder) {
        ArtifactFilter transitiveDependencyFilter = this.createTransitiveDependencyFilter(project);
        if (this.dependencyGraphBuilder != null) {
            this.createGraph(project, globalFilter, transitiveDependencyFilter, graphBuilder);
        } else {
            this.createTree(project, globalFilter, transitiveDependencyFilter, graphBuilder);
        }
    }

    private void createGraph(MavenProject project, ArtifactFilter globalFilter, ArtifactFilter transitiveDependencyFilter, GraphBuilder<DependencyNode> graphBuilder) throws DependencyGraphException {
        org.apache.maven.shared.dependency.graph.DependencyNode root;
        try {
            root = this.dependencyGraphBuilder.buildDependencyGraph(project, globalFilter);
        }
        catch (DependencyGraphBuilderException e) {
            throw new DependencyGraphException(e);
        }
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(graphBuilder, transitiveDependencyFilter, this.targetFilter, this.omitReachablePaths);
        root.accept((org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor)visitor);
    }

    private void createTree(MavenProject project, ArtifactFilter globalFilter, ArtifactFilter transitiveDependencyFilter, GraphBuilder<DependencyNode> graphBuilder) throws DependencyGraphException {
        org.apache.maven.shared.dependency.tree.DependencyNode root;
        try {
            root = this.dependencyTreeBuilder.buildDependencyTree(project, this.artifactRepository, globalFilter);
        }
        catch (DependencyTreeBuilderException e) {
            throw new DependencyGraphException(e);
        }
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(graphBuilder, globalFilter, transitiveDependencyFilter, this.targetFilter, this.includedResolutions);
        root.accept((DependencyNodeVisitor)visitor);
    }

    private ArtifactFilter createTransitiveDependencyFilter(MavenProject project) {
        ArrayList<String> dependencyKeys = new ArrayList<String>(project.getDependencies().size());
        for (Dependency dependency : project.getDependencies()) {
            dependencyKeys.add(dependency.getManagementKey());
        }
        OrArtifactFilter artifactFilter = new OrArtifactFilter();
        artifactFilter.add(this.transitiveIncludeExcludeFilter);
        artifactFilter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(dependencyKeys));
        artifactFilter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(Collections.singletonList(project.getArtifact().toString())));
        return artifactFilter;
    }
}

