/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.dot;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.dot.style.StyleConfiguration;
import com.github.ferstl.depgraph.dependency.dot.style.StyleKey;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.google.common.base.Joiner;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DotDependencyNodeNameRenderer
implements NodeRenderer<DependencyNode> {
    private static final Joiner SLASH_JOINER = Joiner.on((String)"/").skipNulls();
    private final boolean showGroupId;
    private final boolean showArtifactId;
    private final boolean showTypes;
    private final boolean showClassifiers;
    private final boolean showVersion;
    private final StyleConfiguration styleConfiguration;

    public DotDependencyNodeNameRenderer(boolean showGroupId, boolean showArtifactId, boolean showTypes, boolean showClassifiers, boolean showVersion, StyleConfiguration styleConfiguration) {
        this.showGroupId = showGroupId;
        this.showArtifactId = showArtifactId;
        this.showTypes = showTypes;
        this.showClassifiers = showClassifiers;
        this.showVersion = showVersion;
        this.styleConfiguration = styleConfiguration;
    }

    @Override
    public String render(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String scopes = DotDependencyNodeNameRenderer.createScopeString(node.getScopes());
        String types = DotDependencyNodeNameRenderer.createTypeString(node.getTypes());
        String classifiers = DotDependencyNodeNameRenderer.createClassifierString(node.getClassifiers());
        String effectiveScope = node.getEffectiveScope();
        StyleKey styleKey = StyleKey.create(artifact.getGroupId(), artifact.getArtifactId(), effectiveScope, artifact.getType(), node.getEffectiveVersion(), classifiers);
        return this.styleConfiguration.nodeAttributes(styleKey, this.showGroupId ? artifact.getGroupId() : null, this.showArtifactId ? artifact.getArtifactId() : null, this.showVersion ? node.getEffectiveVersion() : null, this.showTypes ? types : null, this.showClassifiers ? classifiers : null, scopes).toString();
    }

    private static String createScopeString(Set<String> scopes) {
        if (scopes.size() > 1 || !scopes.contains("compile")) {
            return "(" + SLASH_JOINER.join(scopes) + ")";
        }
        return "";
    }

    private static String createTypeString(Set<String> types) {
        if (types.size() > 1 || !types.contains("jar")) {
            LinkedHashSet<String> typesToDisplay = new LinkedHashSet<String>(types.size());
            for (String type : types) {
                typesToDisplay.add("." + type);
            }
            return SLASH_JOINER.join(typesToDisplay);
        }
        return "";
    }

    private static String createClassifierString(Set<String> classifiers) {
        return SLASH_JOINER.join(classifiers);
    }
}

