/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.dot.style;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.dependency.dot.style.AbstractNode;
import com.github.ferstl.depgraph.dependency.dot.style.Box;
import com.github.ferstl.depgraph.dependency.dot.style.Edge;
import com.github.ferstl.depgraph.dependency.dot.style.Graph;
import com.github.ferstl.depgraph.dependency.dot.style.NodeResolutionDeserializer;
import com.github.ferstl.depgraph.dependency.dot.style.NodeResolutionSerializer;
import com.github.ferstl.depgraph.dependency.dot.style.StyleKey;
import com.github.ferstl.depgraph.dependency.dot.style.resource.StyleResource;
import com.github.ferstl.depgraph.graph.dot.DotAttributeBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;

public class StyleConfiguration {
    private final Graph graph = new Graph();
    private AbstractNode defaultNode = new Box();
    private final Edge defaultEdge = new Edge();
    private final Map<StyleKey, AbstractNode> nodeStyles = new LinkedHashMap<StyleKey, AbstractNode>();
    private final Map<String, Edge> edgeScopeStyles = new LinkedHashMap<String, Edge>();
    private final Map<StyleKey, Edge> edgeNodeStylesFrom = new LinkedHashMap<StyleKey, Edge>();
    private final Map<StyleKey, Edge> edgeNodeStylesTo = new LinkedHashMap<StyleKey, Edge>();
    private final Map<NodeResolution, Edge> edgeResolutionStyles = new LinkedHashMap<NodeResolution, Edge>();

    public static StyleConfiguration load(StyleResource mainConfig, StyleResource ... overrides) {
        ObjectMapper mapper = StyleConfiguration.createObjectMapper();
        ObjectReader reader = mapper.readerFor(StyleConfiguration.class);
        StyleConfiguration styleConfiguration = StyleConfiguration.readConfig(reader, mainConfig);
        for (StyleResource override : overrides) {
            StyleConfiguration overrideConfig = StyleConfiguration.readConfig(reader, override);
            styleConfiguration.merge(overrideConfig);
        }
        return styleConfiguration;
    }

    private static ObjectMapper createObjectMapper() {
        SimpleModule module = new SimpleModule().addKeySerializer(NodeResolution.class, (JsonSerializer)new NodeResolutionSerializer()).addDeserializer(NodeResolution.class, (JsonDeserializer)new NodeResolutionDeserializer());
        return new ObjectMapper().registerModule((Module)module).setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StyleConfiguration readConfig(ObjectReader reader, StyleResource config) {
        try (InputStream is = config.openStream();){
            StyleConfiguration styleConfiguration = (StyleConfiguration)reader.readValue(is);
            return styleConfiguration;
        }
        catch (JsonProcessingException e) {
            String message = String.format("Unable to read style configuration %s.\nLocation: line %s, column %s\nDetails: %s", config, e.getLocation().getLineNr(), e.getLocation().getColumnNr(), e.getOriginalMessage());
            throw new RuntimeException(message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DotAttributeBuilder graphAttributes() {
        return this.graph.createAttributes();
    }

    public DotAttributeBuilder defaultNodeAttributes() {
        return this.defaultNode.createAttributes();
    }

    public DotAttributeBuilder defaultEdgeAttributes() {
        return this.defaultEdge.createAttributes();
    }

    public DotAttributeBuilder edgeAttributes(NodeResolution resolution, String targetScope, Artifact from, Artifact to) {
        StyleKey styleKey;
        Edge edge = this.edgeResolutionStyles.get((Object)resolution);
        if (resolution == NodeResolution.INCLUDED && this.edgeScopeStyles.containsKey(targetScope)) {
            edge = this.edgeScopeStyles.get(targetScope);
        }
        if (from != null) {
            StyleKey artifactKeyFrom = StyleKey.create(from.getGroupId(), from.getArtifactId(), from.getScope(), from.getType(), from.getVersion(), from.getClassifier());
            for (Map.Entry<StyleKey, Edge> entry : this.edgeNodeStylesFrom.entrySet()) {
                styleKey = entry.getKey();
                if (!styleKey.matches(artifactKeyFrom)) continue;
                edge = entry.getValue();
                break;
            }
        }
        if (to != null) {
            StyleKey artifactKeyTo = StyleKey.create(to.getGroupId(), to.getArtifactId(), to.getScope(), to.getType(), to.getVersion(), to.getClassifier());
            for (Map.Entry<StyleKey, Edge> entry : this.edgeNodeStylesTo.entrySet()) {
                styleKey = entry.getKey();
                if (!styleKey.matches(artifactKeyTo)) continue;
                edge = entry.getValue();
                break;
            }
        }
        return edge != null ? edge.createAttributes() : new DotAttributeBuilder();
    }

    public DotAttributeBuilder nodeAttributes(StyleKey artifactKey, String groupId, String artifactId, String version, String types, String classifiers, String scopes) {
        AbstractNode node = this.defaultNode;
        for (Map.Entry<StyleKey, AbstractNode> entry : this.nodeStyles.entrySet()) {
            StyleKey styleKey = entry.getKey();
            if (!styleKey.matches(artifactKey)) continue;
            node = entry.getValue();
            break;
        }
        return node.createAttributes(groupId, artifactId, version, types, scopes, classifiers, node != this.defaultNode);
    }

    public String toJson() {
        ObjectMapper mapper = StyleConfiguration.createObjectMapper();
        try {
            StringWriter w = new StringWriter();
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)w, (Object)this);
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void merge(StyleConfiguration other) {
        Edge edge;
        StyleKey styleKey;
        this.graph.merge(other.graph);
        this.defaultNode.merge(other.defaultNode);
        other.defaultNode.merge(this.defaultNode);
        this.defaultNode = other.defaultNode;
        this.defaultEdge.merge(other.defaultEdge);
        for (Map.Entry<StyleKey, AbstractNode> entry : other.nodeStyles.entrySet()) {
            styleKey = entry.getKey();
            AbstractNode node = entry.getValue();
            if (this.nodeStyles.containsKey(styleKey)) {
                AbstractNode originalNode = this.nodeStyles.get(styleKey);
                originalNode.merge(node);
                node.merge(originalNode);
                this.nodeStyles.put(styleKey, node);
                continue;
            }
            this.nodeStyles.put(styleKey, node);
        }
        for (Map.Entry<Object, Object> entry : other.edgeResolutionStyles.entrySet()) {
            NodeResolution resolution = (NodeResolution)((Object)entry.getKey());
            edge = (Edge)entry.getValue();
            if (this.edgeResolutionStyles.containsKey((Object)resolution)) {
                this.edgeResolutionStyles.get((Object)resolution).merge(edge);
                continue;
            }
            this.edgeResolutionStyles.put(resolution, edge);
        }
        for (Map.Entry<Object, Object> entry : other.edgeScopeStyles.entrySet()) {
            String scope = (String)entry.getKey();
            edge = (Edge)entry.getValue();
            if (this.edgeScopeStyles.containsKey(scope)) {
                this.edgeScopeStyles.get(scope).merge(edge);
                continue;
            }
            this.edgeScopeStyles.put(scope, edge);
        }
        for (Map.Entry<Object, Object> entry : other.edgeNodeStylesFrom.entrySet()) {
            styleKey = (StyleKey)entry.getKey();
            edge = (Edge)entry.getValue();
            if (this.edgeNodeStylesFrom.containsKey(styleKey)) {
                this.edgeNodeStylesFrom.get(styleKey).merge(edge);
                continue;
            }
            this.edgeNodeStylesFrom.put(styleKey, edge);
        }
        for (Map.Entry<Object, Object> entry : other.edgeNodeStylesTo.entrySet()) {
            styleKey = (StyleKey)entry.getKey();
            edge = (Edge)entry.getValue();
            if (this.edgeNodeStylesTo.containsKey(styleKey)) {
                this.edgeNodeStylesTo.get(styleKey).merge(edge);
                continue;
            }
            this.edgeNodeStylesTo.put(styleKey, edge);
        }
    }
}

