/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph;

import com.github.ferstl.depgraph.graph.Edge;
import com.github.ferstl.depgraph.graph.EdgeRenderer;
import com.github.ferstl.depgraph.graph.GraphFormatter;
import com.github.ferstl.depgraph.graph.Node;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.github.ferstl.depgraph.graph.dot.DotAttributeBuilder;
import com.github.ferstl.depgraph.graph.dot.DotGraphFormatter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class GraphBuilder<T> {
    private final NodeRenderer<? super T> nodeIdRenderer;
    private final Map<String, Node<T>> nodeDefinitions;
    private final Set<Edge> edges;
    private final ReachabilityMap reachabilityMap;
    private String graphName;
    private GraphFormatter graphFormatter;
    private NodeRenderer<? super T> nodeNameRenderer;
    private EdgeRenderer<? super T> edgeRenderer;
    private boolean omitSelfReferences;

    public static <T> GraphBuilder<T> create(NodeRenderer<? super T> nodeIdRenderer) {
        return new GraphBuilder<T>(nodeIdRenderer);
    }

    private GraphBuilder(NodeRenderer<? super T> nodeIdRenderer) {
        this.nodeIdRenderer = nodeIdRenderer;
        this.nodeDefinitions = new LinkedHashMap<String, Node<T>>();
        this.edges = new LinkedHashSet<Edge>();
        this.reachabilityMap = new ReachabilityMap();
        DotAttributeBuilder graphAttributeBuilder = new DotAttributeBuilder();
        DotAttributeBuilder nodeAttributeBuilder = new DotAttributeBuilder().shape("box").fontName("Helvetica");
        DotAttributeBuilder edgeAttributeBuilder = new DotAttributeBuilder().fontName("Helvetica").fontSize(10);
        this.graphName = "G";
        this.graphFormatter = new DotGraphFormatter(graphAttributeBuilder, nodeAttributeBuilder, edgeAttributeBuilder);
        this.nodeNameRenderer = GraphBuilder.createDefaultNodeNameRenderer();
        this.edgeRenderer = GraphBuilder.createDefaultEdgeRenderer();
    }

    public GraphBuilder<T> graphName(String name) {
        this.graphName = name;
        return this;
    }

    public GraphBuilder<T> useNodeNameRenderer(NodeRenderer<? super T> nodeNameRenderer) {
        this.nodeNameRenderer = nodeNameRenderer;
        return this;
    }

    public GraphBuilder<T> useEdgeRenderer(EdgeRenderer<? super T> edgeRenderer) {
        this.edgeRenderer = edgeRenderer;
        return this;
    }

    public GraphBuilder<T> omitSelfReferences() {
        this.omitSelfReferences = true;
        return this;
    }

    public GraphBuilder<T> graphFormatter(GraphFormatter formatter) {
        this.graphFormatter = formatter;
        return this;
    }

    public boolean isEmpty() {
        return this.nodeDefinitions.isEmpty();
    }

    public GraphBuilder<T> addNode(T node) {
        String nodeId = this.nodeIdRenderer.render(node);
        String nodeName = this.nodeNameRenderer.render(node);
        this.nodeDefinitions.put(nodeId, new Node<T>(nodeId, nodeName, node));
        return this;
    }

    public GraphBuilder<T> addEdge(T from, T to) {
        if (from != null && to != null) {
            this.addNode(from);
            this.addNode(to);
            this.safelyAddEdge(from, to);
        }
        return this;
    }

    public T getEffectiveNode(T node) {
        String key = this.nodeIdRenderer.render(node);
        if (this.nodeDefinitions.containsKey(key)) {
            return this.nodeDefinitions.get((Object)key).nodeObject;
        }
        return node;
    }

    public boolean isReachable(T target, T source) {
        String targetId = this.nodeIdRenderer.render(target);
        String sourceId = this.nodeIdRenderer.render(source);
        return this.reachabilityMap.isReachable(targetId, sourceId);
    }

    public String toString() {
        ImmutableList.Builder nodeListBuilder = ImmutableList.builder();
        for (Node<T> node : this.nodeDefinitions.values()) {
            nodeListBuilder.add(node);
        }
        ImmutableList nodeList = nodeListBuilder.build();
        ImmutableSet edgeSet = ImmutableSet.copyOf(this.edges);
        return this.graphFormatter.format(this.graphName, (Collection<Node<?>>)nodeList, (Collection<Edge>)edgeSet);
    }

    private void safelyAddEdge(T fromNode, T toNode) {
        String fromNodeId = this.nodeIdRenderer.render(fromNode);
        String toNodeId = this.nodeIdRenderer.render(toNode);
        if (!this.omitSelfReferences || !fromNodeId.equals(toNodeId)) {
            Edge edge = new Edge(fromNodeId, toNodeId, this.edgeRenderer.render(fromNode, toNode));
            this.edges.add(edge);
            this.reachabilityMap.registerEdge(fromNodeId, toNodeId);
        }
    }

    private static <T> EdgeRenderer<T> createDefaultEdgeRenderer() {
        return new EdgeRenderer<T>(){

            @Override
            public String render(T from, T to) {
                return "";
            }
        };
    }

    private static <T> NodeRenderer<T> createDefaultNodeNameRenderer() {
        return new NodeRenderer<T>(){

            @Override
            public String render(T node) {
                return "";
            }
        };
    }

    private static class ReachabilityMap {
        private final Map<String, Set<String>> parentIndex = new HashMap<String, Set<String>>();

        private ReachabilityMap() {
        }

        void registerEdge(String from, String to) {
            Set<String> parents = this.safelyGetParents(to);
            parents.add(from);
        }

        boolean isReachable(String target, String source) {
            return this.isReachableInternal(target, source, new HashSet<String>());
        }

        private boolean isReachableInternal(String target, String source, Set<String> alreadyVisited) {
            if (alreadyVisited.contains(target)) {
                return false;
            }
            alreadyVisited.add(target);
            Set<String> parents = this.safelyGetParents(target);
            if (parents.contains(source)) {
                return true;
            }
            for (String parent : parents) {
                if (!this.isReachableInternal(parent, source, alreadyVisited)) continue;
                return true;
            }
            return false;
        }

        private Set<String> safelyGetParents(String node) {
            Set<String> parentPath = this.parentIndex.get(node);
            if (parentPath == null) {
                parentPath = new HashSet<String>();
                this.parentIndex.put(node, parentPath);
            }
            return parentPath;
        }
    }
}

