/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph.puml;

import com.github.ferstl.depgraph.dependency.puml.PumlEdgeInfo;
import com.github.ferstl.depgraph.dependency.puml.PumlNodeInfo;
import com.github.ferstl.depgraph.graph.Edge;
import com.github.ferstl.depgraph.graph.GraphFormatter;
import com.github.ferstl.depgraph.graph.Node;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class PumlGraphFormatter
implements GraphFormatter {
    @Override
    public String format(String graphName, Collection<Node<?>> nodes, Collection<Edge> edges) {
        StringBuilder puml = new StringBuilder();
        this.startUml(puml);
        this.skinParam(puml);
        this.writeNodes(puml, nodes);
        this.writeEdges(puml, edges);
        this.endUml(puml);
        return puml.toString();
    }

    private void startUml(StringBuilder puml) {
        puml.append("@startuml\n");
    }

    private void skinParam(StringBuilder puml) {
        puml.append("skinparam defaultTextAlignment center\n").append("skinparam rectangle {\n").append("  BackgroundColor<<test>> lightGreen\n").append("  BackgroundColor<<runtime>> lightBlue\n").append("  BackgroundColor<<provided>> lightGray\n").append("}\n");
    }

    private void writeNodes(StringBuilder puml, Collection<Node<?>> nodes) {
        for (Node<?> node : nodes) {
            PumlNodeInfo nodeInfo = PumlNodeInfo.parse(node.getNodeName());
            puml.append(nodeInfo.getComponent()).append(" \"").append(nodeInfo.getLabel()).append("\" as ").append(this.escape(node.getNodeId()));
            if (!nodeInfo.getStereotype().equals("compile")) {
                puml.append("<<").append(nodeInfo.getStereotype()).append(">>");
            }
            puml.append("\n");
        }
    }

    private void writeEdges(StringBuilder puml, Collection<Edge> edges) {
        for (Edge edge : edges) {
            PumlEdgeInfo edgeInfo = PumlEdgeInfo.parse(edge.getName());
            puml.append(this.escape(edge.getFromNodeId())).append(" ").append(edgeInfo.getBegin()).append(edgeInfo.getColor()).append(edgeInfo.getEnd()).append(" ").append(this.escape(edge.getToNodeId()));
            if (edgeInfo.getLabel() != null && !edgeInfo.getLabel().equals("")) {
                puml.append(": ").append(edgeInfo.getLabel());
            }
            puml.append("\n");
        }
    }

    private void endUml(StringBuilder puml) {
        puml.append("@enduml");
    }

    private String escape(String id) {
        return StringUtils.removeEnd((String)id.replaceAll("\\W", "_"), (String)"_");
    }
}

