/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.puml;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.dependency.VersionAbbreviator;
import com.github.ferstl.depgraph.dependency.puml.PumlEdgeInfo;
import com.github.ferstl.depgraph.graph.EdgeRenderer;

public class PumlDependencyEgdeRenderer
implements EdgeRenderer<DependencyNode> {
    private static final String INCLUDE_COLOR = "#000000";
    private static final String DUPLICATE_COLOR = "#D3D3D3";
    private static final String CONFLICT_COLOR = "#FF0000";
    private final boolean renderVersion;

    public PumlDependencyEgdeRenderer(boolean renderVersion) {
        this.renderVersion = renderVersion;
    }

    @Override
    public String render(DependencyNode from, DependencyNode to) {
        NodeResolution resolution = to.getResolution();
        PumlEdgeInfo edgeInfo = new PumlEdgeInfo();
        switch (resolution) {
            case INCLUDED: 
            case PARENT: {
                edgeInfo.withBegin("-[").withColor(INCLUDE_COLOR).withEnd("]->").withLabel("");
                break;
            }
            case OMITTED_FOR_CONFLICT: {
                edgeInfo.withBegin(".[").withColor(CONFLICT_COLOR).withEnd("].>").withLabel(this.renderVersion ? VersionAbbreviator.abbreviateVersion(to.getArtifact().getVersion()) : "");
                break;
            }
            case OMITTED_FOR_DUPLICATE: {
                edgeInfo.withBegin(".[").withColor(DUPLICATE_COLOR).withEnd("].>").withLabel("");
                break;
            }
        }
        return edgeInfo.toString();
    }
}

