/*
 * Copyright (c) 2014 - 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.ferstl.depgraph.dependency.dot.style.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;


public class FileSystemStyleResource implements StyleResource {

  private final Path location;

  public FileSystemStyleResource(Path location) {
    this.location = location;
  }

  @Override
  public boolean exists() {
    return Files.exists(this.location);
  }

  @Override
  public InputStream openStream() throws IOException {
    return Files.newInputStream(this.location, StandardOpenOption.READ);
  }

  @Override
  public String toString() {
    return "file:" + this.location;
  }
}
