/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.ferstl.depgraph.graph.Edge;
import com.github.ferstl.depgraph.graph.GraphFormatter;
import com.github.ferstl.depgraph.graph.Node;
import com.github.ferstl.depgraph.graph.json.JsonGraph;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JsonGraphFormatter
implements GraphFormatter {
    private final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);

    @Override
    public String format(String graphName, Collection<Node<?>> nodes, Collection<Edge> edges) {
        HashMap<String, Integer> nodeIdMap = new HashMap<String, Integer>(nodes.size());
        JsonGraph jsonGraph = new JsonGraph(graphName);
        int numericNodeId = 0;
        for (Node<?> node : nodes) {
            String nodeId = node.getNodeId();
            nodeIdMap.put(nodeId, numericNodeId++);
            jsonGraph.addArtifact(nodeId, numericNodeId, this.readJson(node.getNodeName()));
        }
        for (Edge edge : edges) {
            String fromNodeId = edge.getFromNodeId();
            Integer fromNodeIdNumeric = (Integer)nodeIdMap.get(fromNodeId);
            String toNodeId = edge.getToNodeId();
            Integer toNodeIdNumeric = (Integer)nodeIdMap.get(toNodeId);
            jsonGraph.addDependency(fromNodeId, fromNodeIdNumeric, toNodeId, toNodeIdNumeric, this.readJson(edge.getName()));
        }
        return this.serialize(jsonGraph);
    }

    private Map<?, ?> readJson(String json) {
        try {
            return (Map)this.objectMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read JSON '" + json + "'", e);
        }
    }

    private String serialize(JsonGraph jsonGraph) {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
        ObjectWriter writer = this.objectMapper.writer((PrettyPrinter)prettyPrinter);
        StringWriter jsonWriter = new StringWriter();
        try {
            writer.writeValue((Writer)jsonWriter, (Object)jsonGraph);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return jsonWriter.toString();
    }
}

