/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.MavenGraphAdapter;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;

public class SimpleGraphFactory
implements GraphFactory {
    private final MavenGraphAdapter mavenGraphAdapter;
    private final ArtifactFilter globalFilter;
    private final GraphBuilder<DependencyNode> graphBuilder;

    public SimpleGraphFactory(MavenGraphAdapter mavenGraphAdapter, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder) {
        this.mavenGraphAdapter = mavenGraphAdapter;
        this.globalFilter = globalFilter;
        this.graphBuilder = graphBuilder;
    }

    @Override
    public String createGraph(MavenProject project) {
        this.graphBuilder.graphName(project.getArtifactId());
        this.mavenGraphAdapter.buildDependencyGraph(project, this.globalFilter, this.graphBuilder);
        Artifact artifact = project.getArtifact();
        if (this.graphBuilder.isEmpty() && this.globalFilter.include(artifact)) {
            this.graphBuilder.addNode(new DependencyNode(artifact));
        }
        return this.graphBuilder.toString();
    }
}

