/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.jarscan;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.jarscan.JarScan;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;

abstract class AbstractJarScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="reportFile")
    private File reportFile;
    @Parameter(property="packages", defaultValue="")
    private List<String> packages;
    @Parameter(property="analyzeDependencies", defaultValue="false")
    private boolean analyzeDependencies;
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="includes", defaultValue="")
    private List<String> includes;
    @Parameter(property="excludes", defaultValue="")
    private List<String> excludes;

    AbstractJarScanMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String errorMessage = this.validateMojoParameters();
        if (errorMessage != null) {
            throw new MojoFailureException(errorMessage);
        }
        this.analyzeOwnArtifact();
        if (this.analyzeDependencies) {
            this.analyzeDependencies();
        }
    }

    protected abstract IJarScanOperation createOperation();

    protected String validateMojoParameters() {
        return null;
    }

    private void analyzeOwnArtifact() throws MojoExecutionException {
        if (!"pom".equals(this.project.getPackaging())) {
            String buildDirectory = this.project.getBuild().getDirectory();
            String finalName = this.project.getBuild().getFinalName();
            Path jarFile = Paths.get(buildDirectory, finalName + ".jar");
            if (Files.exists(jarFile, new LinkOption[0])) {
                this.scanAndprintReport(this.project.getArtifact().toString(), jarFile.toFile());
            } else {
                this.getLog().warn((CharSequence)("JAR file not found: " + jarFile));
            }
        }
    }

    private void analyzeDependencies() throws MojoExecutionException {
        Set dependencies = this.project.getDependencyArtifacts();
        ArtifactFilter filter = this.createArtifactFilter();
        for (Artifact dependency : dependencies) {
            if (!filter.include(dependency)) continue;
            this.getLog().debug((CharSequence)("Analyzing " + dependency));
            this.scanAndprintReport(dependency.toString(), dependency.getFile());
        }
    }

    private void scanAndprintReport(String name, File file) throws MojoExecutionException {
        IJarScanOperation operation = this.createOperation();
        JarScan jarScan = new JarScan(operation);
        for (String prefix : this.packages) {
            prefix = prefix.replace("*", "");
            jarScan.addAllowedPackagePrefix(prefix);
        }
        try (PrintWriter writer = this.createReportWriter();){
            jarScan.iterateJar(file);
            writer.println("Artifact: " + name);
            writer.println(operation.getReport());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private ArtifactFilter createArtifactFilter() {
        ArrayList<Object> filters = new ArrayList<Object>(3);
        if (this.scope != null) {
            filters.add(new ScopeArtifactFilter(this.scope));
        }
        if (!this.includes.isEmpty()) {
            filters.add(new StrictPatternIncludesArtifactFilter(this.includes));
        }
        if (!this.excludes.isEmpty()) {
            filters.add(new StrictPatternExcludesArtifactFilter(this.excludes));
        }
        return new AndArtifactFilter(filters);
    }

    private PrintWriter createReportWriter() throws IOException {
        if (this.reportFile != null) {
            BufferedWriter bw = Files.newBufferedWriter(this.reportFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return new PrintWriter(bw);
        }
        return new PrintWriter(new OutputStreamWriter(System.out)){

            @Override
            public void close() {
                this.flush();
            }
        };
    }
}

