/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.allocationcount;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.adoptopenjdk.jitwatch.model.bytecode.Opcode;

public class AllocCountMap {
    private Map<String, Integer> typeCountMap = new TreeMap<String, Integer>();

    public void countAllocationOfType(String type) {
        Integer count = this.typeCountMap.get(type);
        if (count == null) {
            count = new Integer(1);
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.typeCountMap.put(type, count);
    }

    public String toString(Opcode prefix, int limitPerInvoke) {
        StringBuilder builder = new StringBuilder();
        ArrayList<Map.Entry<String, Integer>> sortedList = new ArrayList<Map.Entry<String, Integer>>(this.typeCountMap.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        int outputCount = 0;
        for (Map.Entry entry : sortedList) {
            String methodName = (String)entry.getKey();
            Integer count = (Integer)entry.getValue();
            builder.append('\"').append(prefix.getMnemonic()).append('\"').append(',');
            builder.append('\"').append(methodName).append('\"').append(',');
            builder.append(count).append("\n");
            if (limitPerInvoke == 0 || ++outputCount != limitPerInvoke) continue;
            break;
        }
        return builder.toString();
    }
}

