/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.freqinlinesize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public class FreqInlineSizeOperation
implements IJarScanOperation {
    private int freqInlineSize;
    private Map<MemberSignatureParts, Integer> countMap = new HashMap<MemberSignatureParts, Integer>();

    public FreqInlineSizeOperation(int freqInlineSize) {
        this.freqInlineSize = freqInlineSize;
    }

    @Override
    public String getReport() {
        ArrayList<Map.Entry<MemberSignatureParts, Integer>> sortedList = new ArrayList<Map.Entry<MemberSignatureParts, Integer>>(this.countMap.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<MemberSignatureParts, Integer>>(){

            @Override
            public int compare(Map.Entry<MemberSignatureParts, Integer> o1, Map.Entry<MemberSignatureParts, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : sortedList) {
            MemberSignatureParts msp = (MemberSignatureParts)entry.getKey();
            int bytecodeSize = (Integer)entry.getValue();
            String fqClassName = msp.getFullyQualifiedClassName();
            builder.append('\"');
            builder.append(StringUtil.getPackageName(fqClassName));
            builder.append('\"');
            builder.append(',');
            builder.append('\"');
            builder.append(StringUtil.getUnqualifiedClassName(fqClassName));
            builder.append('\"');
            builder.append(',');
            builder.append('\"');
            builder.append(msp.getMemberName());
            builder.append('\"');
            builder.append(',');
            builder.append('\"');
            if (msp.getParamTypes().size() > 0) {
                for (String param : msp.getParamTypes()) {
                    builder.append(param).append(',');
                }
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append('\"');
            builder.append(',');
            builder.append(bytecodeSize);
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        if (instructions != null && instructions.size() > 0) {
            BytecodeInstruction lastInstruction = instructions.get(instructions.size() - 1);
            int bcSize = 1 + lastInstruction.getOffset();
            MemberSignatureParts msp = memberBytecode.getMemberSignatureParts();
            if (bcSize >= this.freqInlineSize && !"<clinit>".equals(msp.getMemberName())) {
                this.countMap.put(msp, bcSize);
            }
        }
    }
}

