/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.jarscan.methodlength;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.jarscan.IJarScanOperation;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public class MethodLengthOperation
implements IJarScanOperation {
    private int findSize;
    private Map<MemberSignatureParts, Integer> methodMap = new HashMap<MemberSignatureParts, Integer>();

    public MethodLengthOperation(int findSize) {
        this.findSize = findSize;
    }

    @Override
    public String getReport() {
        ArrayList<Map.Entry<MemberSignatureParts, Integer>> sortedList = new ArrayList<Map.Entry<MemberSignatureParts, Integer>>(this.methodMap.entrySet());
        Collections.sort(sortedList, new Comparator<Map.Entry<MemberSignatureParts, Integer>>(){

            @Override
            public int compare(Map.Entry<MemberSignatureParts, Integer> o1, Map.Entry<MemberSignatureParts, Integer> o2) {
                return o1.getKey().toStringSingleLine().compareTo(o2.getKey().toStringSingleLine());
            }
        });
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : sortedList) {
            MemberSignatureParts msp = (MemberSignatureParts)entry.getKey();
            int bytecodeSize = (Integer)entry.getValue();
            String fqClassName = msp.getFullyQualifiedClassName();
            builder.append('\"');
            builder.append(StringUtil.getPackageName(fqClassName));
            builder.append('\"');
            builder.append(',');
            builder.append('\"');
            builder.append(StringUtil.getUnqualifiedClassName(fqClassName));
            builder.append('\"');
            builder.append(',');
            builder.append('\"');
            builder.append(msp.getMemberName());
            builder.append('\"');
            builder.append(',');
            builder.append('\"');
            if (msp.getParamTypes().size() > 0) {
                for (String param : msp.getParamTypes()) {
                    builder.append(param).append(',');
                }
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append('\"');
            builder.append(',');
            builder.append(bytecodeSize);
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public void processInstructions(String className, MemberBytecode memberBytecode) {
        List<BytecodeInstruction> instructions = memberBytecode.getInstructions();
        if (instructions != null && instructions.size() > 0) {
            BytecodeInstruction lastInstruction = instructions.get(instructions.size() - 1);
            int bcSize = 1 + lastInstruction.getOffset();
            MemberSignatureParts msp = memberBytecode.getMemberSignatureParts();
            if (bcSize == this.findSize && !"<clinit>".equals(msp.getMemberName())) {
                this.methodMap.put(msp, bcSize);
            }
        }
    }
}

