/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.util.ParseUtil;

public class Journal {
    private List<Tag> entryList = new ArrayList<Tag>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Tag entry) {
        List<Tag> list = this.entryList;
        synchronized (list) {
            this.entryList.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tag> getEntryList() {
        List<Tag> list = this.entryList;
        synchronized (list) {
            ArrayList<Tag> copy = new ArrayList<Tag>(this.entryList);
            Collections.sort(copy, new Comparator<Tag>(){

                @Override
                public int compare(Tag tag1, Tag tag2) {
                    long ts1 = ParseUtil.getStamp(tag1.getAttributes());
                    long ts2 = ParseUtil.getStamp(tag2.getAttributes());
                    return Long.compare(ts1, ts2);
                }
            });
            return copy;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Tag tag : this.getEntryList()) {
            builder.append(tag.toString(true)).append('\n');
        }
        return builder.toString();
    }
}

