/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.MetaPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManager {
    private static final Logger logger = LoggerFactory.getLogger(PackageManager.class);
    private Map<String, MetaClass> metaClasses;
    private Map<String, MetaPackage> metaPackages;
    private List<MetaPackage> roots;

    public PackageManager() {
        this.clear();
    }

    public final void clear() {
        this.metaClasses = new ConcurrentHashMap<String, MetaClass>();
        this.metaPackages = new ConcurrentHashMap<String, MetaPackage>();
        this.roots = new CopyOnWriteArrayList<MetaPackage>();
    }

    public void addMetaClass(MetaClass metaClass) {
        this.metaClasses.put(metaClass.getFullyQualifiedName(), metaClass);
    }

    public MetaClass getMetaClass(String className) {
        MetaClass result = null;
        if (className != null) {
            result = this.metaClasses.get(className);
        }
        return result;
    }

    public MetaPackage getMetaPackage(String packageName) {
        MetaPackage result = null;
        if (packageName != null) {
            result = this.metaPackages.get(packageName);
        }
        return result;
    }

    public MetaPackage buildPackage(String packageName) {
        String[] parts = packageName.split("\\.");
        StringBuilder builder = new StringBuilder();
        MetaPackage mp = null;
        MetaPackage parent = null;
        int depth = 0;
        for (String part : parts) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
            String nameBuild = builder.toString();
            mp = this.metaPackages.get(nameBuild);
            if (mp == null) {
                mp = new MetaPackage(nameBuild);
                if (depth == 0) {
                    this.roots.add(mp);
                } else {
                    parent.addChildPackage(mp);
                }
                this.metaPackages.put(nameBuild, mp);
            }
            parent = mp;
            ++depth;
        }
        if (mp == null) {
            mp = new MetaPackage("");
            this.metaPackages.put("", mp);
        }
        return mp;
    }

    public List<MetaPackage> getRootPackages() {
        return this.roots;
    }
}

