/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.assembly;

import java.util.ArrayList;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyBlock;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyInstruction;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public class AssemblyMethod {
    private String header;
    private List<AssemblyBlock> blocks = new ArrayList<AssemblyBlock>();

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void addBlock(AssemblyBlock block) {
        this.blocks.add(block);
    }

    public List<AssemblyBlock> getBlocks() {
        return this.blocks;
    }

    public int getMaxAnnotationWidth() {
        int width = 0;
        for (AssemblyBlock block : this.blocks) {
            for (AssemblyInstruction instruction : block.getInstructions()) {
                int annoWidth = instruction.getAnnotation().length();
                width = Math.max(width, annoWidth);
            }
        }
        return width;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int maxAnnoWidth = this.getMaxAnnotationWidth();
        if (this.header != null) {
            String[] headerLines;
            for (String headerLine : headerLines = this.header.split("\n")) {
                builder.append(StringUtil.repeat(' ', maxAnnoWidth));
                builder.append(headerLine).append("\n");
            }
        }
        for (AssemblyBlock block : this.blocks) {
            builder.append(block.toString(maxAnnoWidth));
        }
        return builder.toString();
    }
}

