/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.adoptopenjdk.jitwatch.model.bytecode.LineAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeAnnotations {
    private static final Logger logger = LoggerFactory.getLogger(BytecodeAnnotations.class);
    private Map<Integer, List<LineAnnotation>> annotationMap = new TreeMap<Integer, List<LineAnnotation>>();

    public void addAnnotation(int bci, LineAnnotation annotation) {
        List<LineAnnotation> existingAnnotations = this.annotationMap.get(bci);
        if (existingAnnotations == null) {
            existingAnnotations = new ArrayList<LineAnnotation>();
            this.annotationMap.put(bci, existingAnnotations);
        }
        existingAnnotations.add(annotation);
    }

    public List<LineAnnotation> getAnnotationsForBCI(int bci) {
        return this.annotationMap.get(bci);
    }

    public boolean hasAnnotationsForBCI(int bci) {
        return this.annotationMap.containsKey(bci);
    }

    public void clear() {
        this.annotationMap.clear();
    }

    public int annotatedLineCount() {
        return this.annotationMap.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Integer, List<LineAnnotation>> entry : this.annotationMap.entrySet()) {
            for (LineAnnotation annotation : entry.getValue()) {
                builder.append(entry.getKey()).append(" ").append(":").append(" ");
                builder.append(annotation.toString()).append("\n").append("\n");
            }
        }
        return builder.toString();
    }
}

