/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InnerClassRelationship {
    private String parentClass;
    private String childClass;
    private static final Pattern PATTERN = Pattern.compile("^.*class (.*) of class (.*)");

    private InnerClassRelationship() {
    }

    public static InnerClassRelationship parse(String line) {
        InnerClassRelationship result = null;
        Matcher matcher = PATTERN.matcher(line);
        if (matcher.find()) {
            result = new InnerClassRelationship();
            result.childClass = matcher.group(1) == null ? null : matcher.group(1).replace("/", ".");
            result.parentClass = matcher.group(2) == null ? null : matcher.group(2).replace("/", ".");
        }
        return result;
    }

    public String getParentClass() {
        return this.parentClass;
    }

    public String getChildClass() {
        return this.childClass;
    }

    public String toString() {
        return "InnerClassRelationship [parentClass=" + this.parentClass + ", childClass=" + this.childClass + "]";
    }
}

