/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import org.adoptopenjdk.jitwatch.model.Tag;

public class UncommonTrap {
    private int bci;
    private String reason;
    private String action;
    private String comment;

    public int getBCI() {
        return this.bci;
    }

    public String getReason() {
        return this.reason;
    }

    public String getAction() {
        return this.action;
    }

    public String getComment() {
        return this.comment;
    }

    public UncommonTrap(int bci, String reason, String action, String comment) {
        this.bci = bci;
        this.reason = reason;
        this.action = action;
        this.comment = comment;
    }

    public static UncommonTrap parse(Tag tag) {
        UncommonTrap trap = null;
        String bci = tag.getAttribute("bci");
        String reason = tag.getAttribute("reason");
        String action = tag.getAttribute("action");
        String comment = tag.getAttribute("comment");
        if (bci != null) {
            int bciValue = Integer.valueOf(bci);
            trap = new UncommonTrap(bciValue, reason, action, comment);
        }
        return trap;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Uncommon trap");
        builder.append(" (");
        builder.append("reason:");
        builder.append(this.reason);
        builder.append(", action:");
        builder.append(this.action);
        if (this.comment != null) {
            builder.append(" comment:");
            builder.append(this.comment);
        }
        builder.append(")");
        return builder.toString();
    }
}

