/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.optimizedvcall;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.model.LogParseException;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyBlock;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyInstruction;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyMethod;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.adoptopenjdk.jitwatch.model.bytecode.SourceMapper;
import org.adoptopenjdk.jitwatch.optimizedvcall.OptimizedVirtualCall;
import org.adoptopenjdk.jitwatch.optimizedvcall.VirtualCallSite;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedVirtualCallFinder {
    private static final Logger logger = LoggerFactory.getLogger(OptimizedVirtualCallFinder.class);
    private IReadOnlyJITDataModel model;
    private List<String> classLocations = new ArrayList<String>();

    public OptimizedVirtualCallFinder(IReadOnlyJITDataModel model, List<String> classLocations) {
        this.model = model;
        this.classLocations = classLocations;
    }

    public OptimizedVirtualCall findOptimizedCall(AssemblyInstruction instruction) {
        OptimizedVirtualCall result = null;
        if (instruction != null && instruction.isOptimizedVCall()) {
            VirtualCallSite callSite = instruction.getOptimizedVirtualCallSiteOrNull();
            result = this.getOptimizedVirtualCall(callSite);
        }
        return result;
    }

    public OptimizedVirtualCall getOptimizedVirtualCall(VirtualCallSite callSite) {
        OptimizedVirtualCall result = null;
        if (callSite != null) {
            BytecodeInstruction bytecodeInstruction = null;
            MemberBytecode memberBytecode = this.getMemberBytecodeForCallSite(callSite);
            if (memberBytecode != null) {
                IMetaMember callerMember = this.findMember(memberBytecode.getMemberSignatureParts());
                bytecodeInstruction = memberBytecode.getBytecodeAtOffset(callSite.getBytecodeOffset());
                if (bytecodeInstruction != null) {
                    IMetaMember calleeMember = null;
                    try {
                        calleeMember = ParseUtil.getMemberFromBytecodeComment(this.model, callerMember, bytecodeInstruction);
                    }
                    catch (LogParseException e) {
                        logger.error("Could not get member from bytecode comment", (Throwable)e);
                    }
                    if (callerMember != null && calleeMember != null) {
                        result = new OptimizedVirtualCall(callerMember, calleeMember, callSite, bytecodeInstruction);
                    } else {
                        logger.error("Could not create OVC from\ncaller: {}\ncallee: {}\nCallSite was: {}", new Object[]{callerMember, calleeMember, callSite});
                    }
                } else {
                    logger.error("Could not find BytecodeInstruction for VCS: {}", (Object)callSite);
                }
            }
        }
        return result;
    }

    public IMetaMember findMember(MemberSignatureParts msp) {
        IMetaMember result = null;
        String metaClassName = msp.getFullyQualifiedClassName();
        MetaClass metaClass = this.model.getPackageManager().getMetaClass(metaClassName);
        if (metaClass != null) {
            result = metaClass.getMemberForSignature(msp);
        }
        return result;
    }

    private MemberBytecode getMemberBytecodeForCallSite(VirtualCallSite callSite) {
        MemberBytecode result = null;
        if (callSite != null) {
            ClassBC classBC;
            String callerClass = callSite.getClassName();
            MetaClass metaClass = this.model.getPackageManager().getMetaClass(callerClass);
            if (metaClass != null && (classBC = metaClass.getClassBytecode(this.model, this.classLocations)) != null) {
                result = SourceMapper.getMemberBytecodeForSourceLine(classBC, callSite.getSourceLine());
            }
        }
        return result;
    }

    public List<OptimizedVirtualCall> findOptimizedCalls(IMetaMember member) {
        HashSet<OptimizedVirtualCall> squashDuplicatesSet = new HashSet<OptimizedVirtualCall>();
        List<AssemblyMethod> assemblyMethods = member.getAssemblyMethods();
        AssemblyMethod asmMethod = assemblyMethods.get(assemblyMethods.size() - 1);
        if (asmMethod != null) {
            for (AssemblyBlock block : asmMethod.getBlocks()) {
                squashDuplicatesSet.addAll(this.findInstructionsForBlock(member, block));
            }
        }
        ArrayList<OptimizedVirtualCall> result = new ArrayList<OptimizedVirtualCall>(squashDuplicatesSet);
        return result;
    }

    public List<OptimizedVirtualCall> findInstructionsForBlock(IMetaMember member, AssemblyBlock block) {
        ArrayList<OptimizedVirtualCall> result = new ArrayList<OptimizedVirtualCall>();
        for (AssemblyInstruction instruction : block.getInstructions()) {
            OptimizedVirtualCall optimizedVCall = this.findOptimizedCall(instruction);
            if (optimizedVCall == null || result.contains(optimizedVCall)) continue;
            result.add(optimizedVCall);
        }
        return result;
    }
}

