/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.optimizedvcall;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.optimizedvcall.OptimizedVirtualCall;
import org.adoptopenjdk.jitwatch.optimizedvcall.OptimizedVirtualCallFinder;
import org.adoptopenjdk.jitwatch.treevisitor.ITreeVisitable;
import org.adoptopenjdk.jitwatch.treevisitor.TreeVisitor;

public class OptimizedVirtualCallVisitable
implements ITreeVisitable {
    private List<OptimizedVirtualCall> optimizedVCallReport = new ArrayList<OptimizedVirtualCall>();
    private OptimizedVirtualCallFinder finder;

    public List<OptimizedVirtualCall> buildOptimizedCalleeReport(IReadOnlyJITDataModel model, List<String> classLocations) {
        this.finder = new OptimizedVirtualCallFinder(model, classLocations);
        TreeVisitor.walkTree(model, this);
        Collections.sort(this.optimizedVCallReport, new Comparator<OptimizedVirtualCall>(){

            @Override
            public int compare(OptimizedVirtualCall o1, OptimizedVirtualCall o2) {
                return o1.getCallerMember().getFullyQualifiedMemberName().compareTo(o2.getCallerMember().getFullyQualifiedMemberName());
            }
        });
        return this.optimizedVCallReport;
    }

    @Override
    public void reset() {
        this.optimizedVCallReport.clear();
    }

    @Override
    public void visit(IMetaMember member) {
        List<OptimizedVirtualCall> vCallsForMember = this.finder.findOptimizedCalls(member);
        this.optimizedVCallReport.addAll(vCallsForMember);
    }
}

