/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyConfigurationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyManagementLocationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyManagementOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyScopeEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.PedanticModuleOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginConfigurationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginManagementLocationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginManagementOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPomSectionOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CompoundPedanticEnforcer
extends AbstractPedanticEnforcer {
    private String pomSectionPriorities;
    private String moduleOrderIgnores;
    private String dependenciesOrderBy;
    private String dependenciesGroupIdPriorities;
    private String dependenciesArtifactIdPriorities;
    private String dependenciesScopePriorities;
    private String dependencyManagementOrderBy;
    private String dependencyManagementGroupIdPriorities;
    private String dependencyManagementArtifactIdPriorities;
    private String dependencyManagementScopePriorities;
    private Boolean allowParentPomsForDependencyManagement;
    private String dependencyManagingPoms;
    private Boolean manageDependencyVersions;
    private Boolean allowUnmangedProjectVersions;
    private Boolean manageDependencyExclusions;
    private String compileDependencies;
    private String providedDependencies;
    private String runtimeDependencies;
    private String systemDependencies;
    private String testDependencies;
    private String importDependencies;
    private String pluginManagementOrderBy;
    private String pluginManagementGroupIdPriorities;
    private String pluginManagementArtifactIdPriorities;
    private Boolean allowParentPomsForPluginManagement;
    private String pluginManagingPoms;
    private Boolean managePluginVersions;
    private Boolean managePluginConfigurations;
    private Boolean managePluginDependencies;
    private final Collection<PedanticEnforcerRule> enforcers = Sets.newLinkedHashSet();
    private final PropertyInitializationVisitor propertyInitializer = new PropertyInitializationVisitor();

    public void setEnforcers(String enforcers) {
        CommaSeparatorUtils.splitAndAddToCollection(enforcers, this.enforcers, PedanticEnforcerRule.stringToEnforcerRule());
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.COMPOUND;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        report.useLargeTitle();
        ArrayList<ErrorReport> ruleErrors = new ArrayList<ErrorReport>();
        for (PedanticEnforcerRule pedanticEnforcer : this.enforcers) {
            AbstractPedanticEnforcer rule = pedanticEnforcer.createEnforcerRule();
            rule.initialize(this.getHelper(), this.getPom(), this.getProjectModel());
            rule.accept(this.propertyInitializer);
            ErrorReport ruleReport = new ErrorReport(rule.getDescription());
            rule.doEnforce(ruleReport);
            if (!ruleReport.hasErrors()) continue;
            ruleErrors.add(ruleReport);
        }
        this.collectErrors(report, ruleErrors);
    }

    private void collectErrors(ErrorReport compundReport, List<ErrorReport> ruleErrors) {
        if (!ruleErrors.isEmpty()) {
            compundReport.useLargeTitle().addLine("Please fix these problems:").emptyLine();
            for (ErrorReport ruleError : ruleErrors) {
                compundReport.addLine(ruleError.toString()).emptyLine().emptyLine();
            }
        }
    }

    private class PropertyInitializationVisitor
    implements PedanticEnforcerVisitor {
        private PropertyInitializationVisitor() {
        }

        @Override
        public void visit(PedanticPomSectionOrderEnforcer enforcer) {
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.pomSectionPriorities)) {
                enforcer.setSectionPriorities(CompoundPedanticEnforcer.this.pomSectionPriorities);
            }
        }

        @Override
        public void visit(PedanticModuleOrderEnforcer enforcer) {
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.moduleOrderIgnores)) {
                enforcer.setIgnoredModules(CompoundPedanticEnforcer.this.moduleOrderIgnores);
            }
        }

        @Override
        public void visit(PedanticDependencyManagementOrderEnforcer enforcer) {
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependencyManagementOrderBy)) {
                enforcer.setOrderBy(CompoundPedanticEnforcer.this.dependencyManagementOrderBy);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependencyManagementGroupIdPriorities)) {
                enforcer.setGroupIdPriorities(CompoundPedanticEnforcer.this.dependencyManagementGroupIdPriorities);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependencyManagementArtifactIdPriorities)) {
                enforcer.setArtifactIdPriorities(CompoundPedanticEnforcer.this.dependencyManagementArtifactIdPriorities);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependencyManagementScopePriorities)) {
                enforcer.setScopePriorities(CompoundPedanticEnforcer.this.dependencyManagementScopePriorities);
            }
        }

        @Override
        public void visit(PedanticDependencyManagementLocationEnforcer enforcer) {
            if (CompoundPedanticEnforcer.this.allowParentPomsForDependencyManagement != null) {
                enforcer.setAllowParentPoms(CompoundPedanticEnforcer.this.allowParentPomsForDependencyManagement);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependencyManagingPoms)) {
                enforcer.setDependencyManagingPoms(CompoundPedanticEnforcer.this.dependencyManagingPoms);
            }
        }

        @Override
        public void visit(PedanticDependencyOrderEnforcer enforcer) {
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependenciesOrderBy)) {
                enforcer.setOrderBy(CompoundPedanticEnforcer.this.dependenciesOrderBy);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependenciesGroupIdPriorities)) {
                enforcer.setGroupIdPriorities(CompoundPedanticEnforcer.this.dependenciesGroupIdPriorities);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependenciesArtifactIdPriorities)) {
                enforcer.setArtifactIdPriorities(CompoundPedanticEnforcer.this.dependenciesArtifactIdPriorities);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.dependenciesScopePriorities)) {
                enforcer.setScopePriorities(CompoundPedanticEnforcer.this.dependenciesScopePriorities);
            }
        }

        @Override
        public void visit(PedanticDependencyConfigurationEnforcer dependencyConfigurationEnforcer) {
            if (CompoundPedanticEnforcer.this.manageDependencyVersions != null) {
                dependencyConfigurationEnforcer.setManageVersions(CompoundPedanticEnforcer.this.manageDependencyVersions);
            }
            if (CompoundPedanticEnforcer.this.allowUnmangedProjectVersions != null) {
                dependencyConfigurationEnforcer.setAllowUnmanagedProjectVersions(CompoundPedanticEnforcer.this.allowUnmangedProjectVersions);
            }
            if (CompoundPedanticEnforcer.this.manageDependencyExclusions != null) {
                dependencyConfigurationEnforcer.setManageExclusions(CompoundPedanticEnforcer.this.manageDependencyExclusions);
            }
        }

        @Override
        public void visit(PedanticDependencyScopeEnforcer dependencyScopeEnforcer) {
            if (CompoundPedanticEnforcer.this.compileDependencies != null) {
                dependencyScopeEnforcer.setCompileDependencies(CompoundPedanticEnforcer.this.compileDependencies);
            }
            if (CompoundPedanticEnforcer.this.providedDependencies != null) {
                dependencyScopeEnforcer.setProvidedDependencies(CompoundPedanticEnforcer.this.providedDependencies);
            }
            if (CompoundPedanticEnforcer.this.runtimeDependencies != null) {
                dependencyScopeEnforcer.setRuntimeDependencies(CompoundPedanticEnforcer.this.runtimeDependencies);
            }
            if (CompoundPedanticEnforcer.this.systemDependencies != null) {
                dependencyScopeEnforcer.setSystemDependencies(CompoundPedanticEnforcer.this.systemDependencies);
            }
            if (CompoundPedanticEnforcer.this.testDependencies != null) {
                dependencyScopeEnforcer.setTestDependencies(CompoundPedanticEnforcer.this.testDependencies);
            }
            if (CompoundPedanticEnforcer.this.importDependencies != null) {
                dependencyScopeEnforcer.setImportDependencies(CompoundPedanticEnforcer.this.importDependencies);
            }
        }

        @Override
        public void visit(PedanticPluginManagementOrderEnforcer enforcer) {
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.pluginManagementOrderBy)) {
                enforcer.setOrderBy(CompoundPedanticEnforcer.this.pluginManagementOrderBy);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.pluginManagementGroupIdPriorities)) {
                enforcer.setGroupIdPriorities(CompoundPedanticEnforcer.this.pluginManagementGroupIdPriorities);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.pluginManagementArtifactIdPriorities)) {
                enforcer.setArtifactIdPriorities(CompoundPedanticEnforcer.this.pluginManagementArtifactIdPriorities);
            }
        }

        @Override
        public void visit(PedanticPluginConfigurationEnforcer enforcer) {
            if (CompoundPedanticEnforcer.this.managePluginVersions != null) {
                enforcer.setManageVersions(CompoundPedanticEnforcer.this.managePluginVersions);
            }
            if (CompoundPedanticEnforcer.this.managePluginConfigurations != null) {
                enforcer.setManageConfigurations(CompoundPedanticEnforcer.this.managePluginConfigurations);
            }
            if (CompoundPedanticEnforcer.this.managePluginDependencies != null) {
                enforcer.setManageDependencies(CompoundPedanticEnforcer.this.managePluginDependencies);
            }
        }

        @Override
        public void visit(PedanticPluginManagementLocationEnforcer enforcer) {
            if (CompoundPedanticEnforcer.this.allowParentPomsForPluginManagement != null) {
                enforcer.setAllowParentPoms(CompoundPedanticEnforcer.this.allowParentPomsForPluginManagement);
            }
            if (!Strings.isNullOrEmpty((String)CompoundPedanticEnforcer.this.pluginManagingPoms)) {
                enforcer.setPluginManagingPoms(CompoundPedanticEnforcer.this.pluginManagingPoms);
            }
        }

        @Override
        public void visit(CompoundPedanticEnforcer enforcer) {
        }
    }
}

