/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.util.SideBySideDiffUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.LinkedList;

public class ErrorReport {
    private static final String LIST_ITEM = "- ";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final Joiner LINE_JOINER = Joiner.on((String)LINE_SEPARATOR);
    private static final Joiner LIST_JOINER = Joiner.on((String)(LINE_SEPARATOR + "- "));
    private final String title;
    private final Collection<Object> lines;
    private boolean useLargeTitle;

    public static <T> String toList(Collection<T> collection) {
        return ErrorReport.toList(collection, Functions.identity());
    }

    public static <T> String toList(Collection<T> collection, Function<T, ?> toStringFunction) {
        return LIST_ITEM + LIST_JOINER.join((Iterable)Collections2.transform(collection, toStringFunction));
    }

    public ErrorReport(PedanticEnforcerRule rule) {
        this.title = rule.name() + ": " + rule.getSlogan();
        this.lines = new LinkedList<Object>();
    }

    public ErrorReport useLargeTitle() {
        this.useLargeTitle = true;
        return this;
    }

    public ErrorReport addLine(Object line) {
        this.lines.add(line);
        return this;
    }

    public ErrorReport addDiff(Collection<String> actual, Collection<String> required, String leftTitle, String rightTitle) {
        String diff = SideBySideDiffUtil.diff(actual, required, leftTitle, rightTitle);
        this.lines.add(diff);
        return this;
    }

    public <T> ErrorReport addDiff(Collection<T> actual, Collection<T> required, String leftTitle, String rightTitle, Function<? super T, String> toStringFunction) {
        Collection actualAsString = Collections2.transform(actual, toStringFunction);
        Collection requiredAsString = Collections2.transform(required, toStringFunction);
        return this.addDiff(actualAsString, requiredAsString, leftTitle, rightTitle);
    }

    public <T> ErrorReport addDiffUsingToString(Collection<T> actual, Collection<T> required, String leftTitle, String rightTitle) {
        return this.addDiff(actual, required, leftTitle, rightTitle, Functions.toStringFunction());
    }

    public ErrorReport formatLine(String line, Object ... params) {
        this.lines.add(String.format(line, params));
        return this;
    }

    public ErrorReport emptyLine() {
        this.lines.add("");
        return this;
    }

    public boolean hasErrors() {
        return !this.lines.isEmpty();
    }

    public String toString() {
        return LINE_JOINER.join((Object)this.formatTitle(), (Object)LINE_JOINER.join(this.lines), new Object[0]);
    }

    private String formatTitle() {
        if (this.useLargeTitle) {
            String border = Strings.repeat((String)"#", (int)(this.title.length() + 4));
            return LINE_JOINER.join((Object)"", (Object)border, new Object[]{"# " + this.title + " #", border, ""});
        }
        return LINE_JOINER.join((Object)("" + this.title), (Object)Strings.repeat((String)"=", (int)this.title.length()), new Object[]{""});
    }
}

