/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;

public class PedanticDependencyConfigurationEnforcer
extends AbstractPedanticEnforcer {
    private boolean manageVersions = true;
    private boolean allowUnmangedProjectVersions = true;
    private boolean manageExclusions = true;

    public void setManageVersions(boolean manageVersions) {
        this.manageVersions = manageVersions;
    }

    public void setAllowUnmanagedProjectVersions(boolean allowUnmangedProjectVersions) {
        this.allowUnmangedProjectVersions = allowUnmangedProjectVersions;
    }

    public void setManageExclusions(boolean manageExclusions) {
        this.manageExclusions = manageExclusions;
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_CONFIGURATION;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        if (this.manageVersions) {
            this.enforceManagedVersions(report);
        }
        if (this.manageExclusions) {
            this.enforceManagedExclusion(report);
        }
    }

    private void enforceManagedVersions(ErrorReport report) {
        Collection versionedDependencies = this.searchForDependencies(DependencyPredicate.WITH_VERSION);
        if (this.allowUnmangedProjectVersions) {
            versionedDependencies = Collections2.filter(versionedDependencies, (Predicate)DependencyPredicate.WITH_PROJECT_VERSION);
        }
        if (!versionedDependencies.isEmpty()) {
            report.addLine("Dependency versions have to be declared in <dependencyManagement>:").addLine(ErrorReport.toList(versionedDependencies));
        }
    }

    private void enforceManagedExclusion(ErrorReport report) {
        Collection<DependencyModel> depsWithExclusions = this.searchForDependencies(DependencyPredicate.WITH_EXCLUSION);
        if (!depsWithExclusions.isEmpty()) {
            report.addLine("Dependency exclusions have to be declared in <dependencyManagement>:").addLine(ErrorReport.toList(depsWithExclusions));
        }
    }

    private Collection<DependencyModel> searchForDependencies(Predicate<DependencyModel> predicate) {
        List<DependencyModel> dependencies = this.getProjectModel().getDependencies();
        return Collections2.filter(dependencies, predicate);
    }

    private static enum DependencyPredicate implements Predicate<DependencyModel>
    {
        WITH_VERSION{

            public boolean apply(DependencyModel input) {
                return input.getVersion() != null;
            }
        }
        ,
        WITH_PROJECT_VERSION{

            public boolean apply(DependencyModel input) {
                return !"${project.version}".equals(input.getVersion()) && !"${version}".equals(input.getVersion());
            }
        }
        ,
        WITH_EXCLUSION{

            public boolean apply(DependencyModel input) {
                return !input.getExclusions().isEmpty();
            }
        };

    }
}

