/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.ArtifactModel;
import com.github.ferstl.maven.pomenforcers.model.DependencyScope;
import com.github.ferstl.maven.pomenforcers.model.functions.StringToArtifactTransformer;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;

public class PedanticDependencyScopeEnforcer
extends AbstractPedanticEnforcer {
    private final Multimap<ArtifactModel, DependencyScope> scopedDependencies = HashMultimap.create();

    public void setCompileDependencies(String compileDependencies) {
        this.addToArtifactMap(this.createDependencyInfo(compileDependencies), DependencyScope.COMPILE);
    }

    public void setProvidedDependencies(String providedDependencies) {
        this.addToArtifactMap(this.createDependencyInfo(providedDependencies), DependencyScope.PROVIDED);
    }

    public void setRuntimeDependencies(String runtimeDependencies) {
        this.addToArtifactMap(this.createDependencyInfo(runtimeDependencies), DependencyScope.RUNTIME);
    }

    public void setSystemDependencies(String systemDependencies) {
        this.addToArtifactMap(this.createDependencyInfo(systemDependencies), DependencyScope.SYSTEM);
    }

    public void setTestDependencies(String testDependencies) {
        this.addToArtifactMap(this.createDependencyInfo(testDependencies), DependencyScope.TEST);
    }

    public void setImportDependencies(String importDependencies) {
        this.addToArtifactMap(this.createDependencyInfo(importDependencies), DependencyScope.IMPORT);
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_SCOPE;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        List dependencies = EnforcerRuleUtils.getMavenProject(this.getHelper()).getDependencies();
        for (Dependency dependency : dependencies) {
            ArtifactModel artifactModel = DependencyToArtifactTransformer.INSTANCE.apply(dependency);
            Collection allowedScopes = this.scopedDependencies.get((Object)artifactModel);
            DependencyScope dependencyScope = this.getScope(dependency);
            if (allowedScopes.isEmpty() || allowedScopes.contains((Object)dependencyScope)) continue;
            report.formatLine("%s -> %s", dependency, Joiner.on((String)", ").join((Iterable)allowedScopes));
        }
    }

    private Set<ArtifactModel> createDependencyInfo(String dependencies) {
        HashSet dependencyInfoSet = Sets.newHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(dependencies, dependencyInfoSet, StringToArtifactTransformer.stringToArtifactModel());
        return dependencyInfoSet;
    }

    private void addToArtifactMap(Iterable<ArtifactModel> artifactModels, DependencyScope scope) {
        for (ArtifactModel artifactModel : artifactModels) {
            this.scopedDependencies.put((Object)artifactModel, (Object)scope);
        }
    }

    private DependencyScope getScope(Dependency dependency) {
        if (dependency.getScope() == null) {
            return DependencyScope.COMPILE;
        }
        return DependencyScope.getByScopeName(dependency.getScope());
    }

    private static enum DependencyToArtifactTransformer implements Function<Dependency, ArtifactModel>
    {
        INSTANCE;


        public ArtifactModel apply(Dependency input) {
            return new ArtifactModel(input.getGroupId(), input.getArtifactId(), input.getVersion());
        }
    }
}

