/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.CompoundPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyConfigurationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyManagementLocationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyManagementOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyScopeEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticModuleOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginConfigurationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginManagementLocationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginManagementOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPomSectionOrderEnforcer;
import com.google.common.base.Function;

public enum PedanticEnforcerRule {
    COMPOUND("One does not simply write a POM file!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            throw new UnsupportedOperationException("The " + CompoundPedanticEnforcer.class.getSimpleName() + " is not supposed to be instantiated outside the maven-enforcer-plugin.");
        }
    }
    ,
    POM_SECTION_ORDER("One does not simply write a POM file!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticPomSectionOrderEnforcer();
        }
    }
    ,
    MODULE_ORDER("One does not simply declare modules!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticModuleOrderEnforcer();
        }
    }
    ,
    DEPENDENCY_MANAGEMENT_ORDER("One does not simply declare dependency management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticDependencyManagementOrderEnforcer();
        }
    }
    ,
    DEPENDENCY_MANAGEMENT_LOCATION("One does not simply declare dependency management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticDependencyManagementLocationEnforcer();
        }
    }
    ,
    DEPENDENCY_ORDER("One does not simply declare dependencies!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticDependencyOrderEnforcer();
        }
    }
    ,
    DEPENDENCY_CONFIGURATION("One does not simply configure dependencies!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticDependencyConfigurationEnforcer();
        }
    }
    ,
    DEPENDENCY_SCOPE("One does not simply declare dependency scopes!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticDependencyScopeEnforcer();
        }
    }
    ,
    PLUGIN_MANAGEMENT_ORDER("One does not simply declare plugin management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticPluginManagementOrderEnforcer();
        }
    }
    ,
    PLUGIN_CONFIGURATION("One does not simply configure plugins!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticPluginConfigurationEnforcer();
        }
    }
    ,
    PLUGIN_MANAGEMENT_LOCATION("One does not simply declare plugin management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule() {
            return new PedanticPluginManagementLocationEnforcer();
        }
    };

    private final String slogan;

    private PedanticEnforcerRule(String slogan) {
        this.slogan = slogan;
    }

    public String getSlogan() {
        return this.slogan;
    }

    public static Function<String, PedanticEnforcerRule> stringToEnforcerRule() {
        return StringToEnforcerRuleTransformer.INSTANCE;
    }

    public abstract AbstractPedanticEnforcer createEnforcerRule();

    private static enum StringToEnforcerRuleTransformer implements Function<String, PedanticEnforcerRule>
    {
        INSTANCE;


        public PedanticEnforcerRule apply(String input) {
            return PedanticEnforcerRule.valueOf(input);
        }
    }
}

