/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.ArtifactModel;
import com.github.ferstl.maven.pomenforcers.model.functions.StringToArtifactTransformer;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class PedanticPluginManagementLocationEnforcer
extends AbstractPedanticEnforcer {
    private boolean allowParentPoms = false;
    private final Set<ArtifactModel> pluginManagingPoms = new HashSet<ArtifactModel>();

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.PLUGIN_MANAGEMENT_LOCATION;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        MavenProject mavenProject = EnforcerRuleUtils.getMavenProject(this.getHelper());
        if (this.containsPluginManagement() && !this.isPluginManagementAllowed(mavenProject)) {
            report.addLine("Only these POMs are allowed to manage plugins:").addLine(ErrorReport.toList(Collections.singletonList("All parent POMs, i.e. POMs with <packaging>pom</packaging>"))).addLine(ErrorReport.toList(this.pluginManagingPoms));
        }
    }

    public void setAllowParentPoms(boolean allowParentPoms) {
        this.allowParentPoms = allowParentPoms;
    }

    public void setPluginManagingPoms(String pluginManagingPoms) {
        CommaSeparatorUtils.splitAndAddToCollection(pluginManagingPoms, this.pluginManagingPoms, StringToArtifactTransformer.stringToArtifactModel());
    }

    private boolean containsPluginManagement() {
        return !this.getProjectModel().getManagedPlugins().isEmpty();
    }

    private boolean isPluginManagementAllowed(MavenProject project) {
        return this.isPluginManagementAllowedInParentPom(project) || this.isPluginManagingProject(project);
    }

    private boolean isPluginManagementAllowedInParentPom(MavenProject project) {
        return this.allowParentPoms && "pom".equals(project.getPackaging());
    }

    private boolean isPluginManagingProject(MavenProject project) {
        ArtifactModel projectInfo = new ArtifactModel(project.getGroupId(), project.getArtifactId(), project.getVersion());
        return this.pluginManagingPoms.isEmpty() || this.pluginManagingPoms.contains(projectInfo);
    }
}

