/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.PluginElement;
import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import com.github.ferstl.maven.pomenforcers.model.functions.PluginMatcher;
import com.github.ferstl.maven.pomenforcers.priority.CompoundPriorityOrdering;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrderingFactory;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

public class PedanticPluginManagementOrderEnforcer
extends AbstractPedanticEnforcer {
    private final CompoundPriorityOrdering<PluginModel, String, PluginElement> pluginOrdering = CompoundPriorityOrdering.orderBy((PriorityOrderingFactory[])new PluginElement[]{PluginElement.GROUP_ID, PluginElement.ARTIFACT_ID});

    public void setOrderBy(String pluginElements) {
        LinkedHashSet orderBy = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(pluginElements, orderBy, PluginElement.stringToPluginElement());
        this.pluginOrdering.redefineOrderBy(orderBy);
    }

    public void setGroupIdPriorities(String groupIds) {
        LinkedHashSet groupIdPriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(groupIds, groupIdPriorities);
        this.pluginOrdering.setPriorities(PluginElement.GROUP_ID, groupIdPriorities);
    }

    public void setArtifactIdPriorities(String artifactIds) {
        LinkedHashSet artifactIdPriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(artifactIds, artifactIdPriorities);
        this.pluginOrdering.setPriorities(PluginElement.ARTIFACT_ID, artifactIdPriorities);
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.PLUGIN_MANAGEMENT_ORDER;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        List managedPlugins;
        MavenProject project = EnforcerRuleUtils.getMavenProject(this.getHelper());
        List<PluginModel> declaredManagedPlugins = this.getProjectModel().getManagedPlugins();
        BiMap<PluginModel, PluginModel> matchedPlugins = this.matchPlugins(declaredManagedPlugins, managedPlugins = project.getPluginManagement().getPlugins());
        Set resolvedPlugins = matchedPlugins.keySet();
        if (!this.pluginOrdering.isOrdered(resolvedPlugins)) {
            ImmutableList sortedPlugins = this.pluginOrdering.immutableSortedCopy(resolvedPlugins);
            report.addLine("Your plugin management has to be ordered this way:").emptyLine().addDiffUsingToString(resolvedPlugins, sortedPlugins, "Actual Order", "Required Order");
        }
    }

    private BiMap<PluginModel, PluginModel> matchPlugins(Collection<PluginModel> subset, Collection<Plugin> superset) {
        return new PluginMatcher(this.getHelper()).match(superset, subset);
    }
}

