/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.PomSection;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PedanticPomSectionOrderEnforcer
extends AbstractPedanticEnforcer {
    private final Set<PomSection> sectionPriorities = Sets.newLinkedHashSet();

    public void setSectionPriorities(String sectionPriorities) {
        CommaSeparatorUtils.splitAndAddToCollection(sectionPriorities, this.sectionPriorities, PomSection.stringToPomSection());
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.POM_SECTION_ORDER;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        Element docElement = this.getPom().getDocumentElement();
        NodeList sectionNodes = docElement.getChildNodes();
        ArrayList<PomSection> pomSections = new ArrayList<PomSection>();
        for (int i = 0; i < sectionNodes.getLength(); ++i) {
            Node node = sectionNodes.item(i);
            if (node.getNodeType() != 1) continue;
            pomSections.add(PomSection.getBySectionName(node.getNodeName()));
        }
        Ordering<PomSection> ordering = PomSection.createPriorityOrdering(this.sectionPriorities);
        if (!ordering.isOrdered(pomSections)) {
            ImmutableList sortedPomSections = ordering.immutableSortedCopy(pomSections);
            report.addLine("Your POM has to be organized this way:").emptyLine().addDiff(pomSections, sortedPomSections, "Actual Order", "Required Order", PomSection.pomSectionToString());
        }
    }
}

