/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.google.common.base.Joiner;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;

public class ArtifactModel {
    private static final Joiner TO_STRING_JOINER = Joiner.on((String)":").useForNull("");
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String groupId;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String artifactId;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String version;

    ArtifactModel() {
    }

    public ArtifactModel(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ArtifactModel(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return TO_STRING_JOINER.join((Object)this.groupId, (Object)this.artifactId, new Object[]{this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtifactModel)) {
            return false;
        }
        ArtifactModel other = (ArtifactModel)obj;
        return com.google.common.base.Objects.equal((Object)this.groupId, (Object)other.groupId) && com.google.common.base.Objects.equal((Object)this.artifactId, (Object)other.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId);
    }
}

