/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import com.github.ferstl.maven.pomenforcers.model.functions.StringStartsWithEquivalence;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrdering;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrderingFactory;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public enum DependencyElement implements PriorityOrderingFactory<String, DependencyModel>,
Function<DependencyModel, String>
{
    GROUP_ID("groupId"){

        @Override
        public PriorityOrdering<String, DependencyModel> createPriorityOrdering(Collection<String> priorityCollection) {
            return new PriorityOrdering<String, DependencyModel>(priorityCollection, this, StringStartsWithEquivalence.stringStartsWith());
        }

        public String apply(DependencyModel input) {
            return input.getGroupId();
        }
    }
    ,
    ARTIFACT_ID("artifactId"){

        @Override
        public PriorityOrdering<String, DependencyModel> createPriorityOrdering(Collection<String> priorityCollection) {
            return new PriorityOrdering<String, DependencyModel>(priorityCollection, this, StringStartsWithEquivalence.stringStartsWith());
        }

        public String apply(DependencyModel input) {
            return input.getArtifactId();
        }
    }
    ,
    SCOPE("scope"){

        @Override
        public PriorityOrdering<String, DependencyModel> createPriorityOrdering(Collection<String> priorityCollection) {
            return new PriorityOrdering<String, DependencyModel>(priorityCollection, this);
        }

        public String apply(DependencyModel input) {
            return input.getScope().getScopeName();
        }
    };

    private static final Map<String, DependencyElement> elementMap;
    private final String elementName;

    public static DependencyElement getByElementName(String elementName) {
        Objects.requireNonNull(elementName, "Element name is null");
        DependencyElement result = elementMap.get(elementName);
        if (result == null) {
            throw new IllegalArgumentException("No dependency element with name " + elementName);
        }
        return result;
    }

    public static Function<String, DependencyElement> stringToDependencyElement() {
        return StringToDependencyElementFunction.INSTANCE;
    }

    private DependencyElement(String elementName) {
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    static {
        elementMap = Maps.newLinkedHashMap();
        for (DependencyElement element : DependencyElement.values()) {
            elementMap.put(element.getElementName(), element);
        }
    }

    private static enum StringToDependencyElementFunction implements Function<String, DependencyElement>
    {
        INSTANCE;


        public DependencyElement apply(String input) {
            return DependencyElement.getByElementName(input);
        }
    }
}

