/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import com.github.ferstl.maven.pomenforcers.model.functions.StringStartsWithEquivalence;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrdering;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrderingFactory;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public enum PluginElement implements PriorityOrderingFactory<String, PluginModel>,
Function<PluginModel, String>
{
    GROUP_ID("groupId"){

        @Override
        public PriorityOrdering<String, PluginModel> createPriorityOrdering(Collection<String> priorityCollection) {
            return new PriorityOrdering<String, PluginModel>(priorityCollection, this, StringStartsWithEquivalence.stringStartsWith());
        }

        public String apply(PluginModel input) {
            return input.getGroupId();
        }
    }
    ,
    ARTIFACT_ID("artifactId"){

        @Override
        public PriorityOrdering<String, PluginModel> createPriorityOrdering(Collection<String> priorityCollection) {
            return new PriorityOrdering<String, PluginModel>(priorityCollection, this, StringStartsWithEquivalence.stringStartsWith());
        }

        public String apply(PluginModel input) {
            return input.getArtifactId();
        }
    };

    private static final Function<String, PluginElement> STRING_TO_PLUGIN_ELEMENT;
    private static final Map<String, PluginElement> elementMap;
    private final String elementName;

    private static PluginElement getByElementName(String elementName) {
        Objects.requireNonNull(elementName, "Element name is null");
        PluginElement result = elementMap.get(elementName);
        if (result == null) {
            throw new IllegalArgumentException("No plugin element with name " + elementName);
        }
        return result;
    }

    public static Function<String, PluginElement> stringToPluginElement() {
        return STRING_TO_PLUGIN_ELEMENT;
    }

    private PluginElement(String elementName) {
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    static {
        STRING_TO_PLUGIN_ELEMENT = new StringToPluginElementTransformer();
        elementMap = Maps.newLinkedHashMap();
        for (PluginElement element : PluginElement.values()) {
            elementMap.put(element.getElementName(), element);
        }
    }

    private static class StringToPluginElementTransformer
    implements Function<String, PluginElement> {
        private StringToPluginElementTransformer() {
        }

        public PluginElement apply(String input) {
            return PluginElement.getByElementName(input);
        }
    }
}

