/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.github.ferstl.maven.pomenforcers.priority.PriorityOrdering;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public enum PomSection {
    MODEL_VERSION("modelVersion"),
    PREREQUISITES("prerequisites"),
    PARENT("parent"),
    GROUP_ID("groupId"),
    ARTIFACT_ID("artifactId"),
    VERSION("version"),
    PACKAGING("packaging"),
    NAME("name"),
    DESCRIPTION("description"),
    URL("url"),
    LICENSES("licenses"),
    ORGANIZATION("organization"),
    INCEPTION_YEAR("inceptionYear"),
    CI_MANAGEMENT("ciManagement"),
    MAILING_LISTS("mailingLists"),
    ISSUE_MANAGEMENT("issueManagement"),
    DEVELOPERS("developers"),
    CONTRIBUTORS("contributors"),
    SCM("scm"),
    REPOSITORIES("repositories"),
    PLUGIN_REPOSITORIES("pluginRepositories"),
    DISTRIBUTION_MANAGEMENT("distributionManagement"),
    MODULES("modules"),
    PROPERTIES("properties"),
    DEPENDENCY_MANAGEMENT("dependencyManagement"),
    DEPENDENCIES("dependencies"),
    BUILD("build"),
    PROFILES("profiles"),
    REPORTING("reporting"),
    REPORTS("reports");

    private static final Map<String, PomSection> pomSectionMap;
    private final String sectionName;

    public static PomSection getBySectionName(String sectionName) {
        Objects.requireNonNull(sectionName, "Section name is null.");
        PomSection value = pomSectionMap.get(sectionName);
        if (value == null) {
            throw new IllegalArgumentException("POM section " + sectionName + " does not exist.");
        }
        return value;
    }

    public static Function<String, PomSection> stringToPomSection() {
        return StringToPomSectionTransformer.INSTANCE;
    }

    public static Function<PomSection, String> pomSectionToString() {
        return PomSectionToStringTransformer.INSTANCE;
    }

    public static Ordering<PomSection> createPriorityOrdering(Collection<PomSection> priorityCollection) {
        return new PriorityOrdering(priorityCollection, Functions.identity());
    }

    private PomSection(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    static {
        pomSectionMap = Maps.newHashMap();
        for (PomSection pomSection : PomSection.values()) {
            pomSectionMap.put(pomSection.getSectionName(), pomSection);
        }
    }

    private static enum PomSectionToStringTransformer implements Function<PomSection, String>
    {
        INSTANCE;


        public String apply(PomSection input) {
            return input.getSectionName();
        }
    }

    private static enum StringToPomSectionTransformer implements Function<String, PomSection>
    {
        INSTANCE;


        public PomSection apply(String input) {
            return PomSection.getBySectionName(input);
        }
    }
}

