/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model.functions;

import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import com.github.ferstl.maven.pomenforcers.model.functions.AbstractOneToOneMatcher;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import java.util.Objects;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Plugin;

public class PluginMatcher
extends AbstractOneToOneMatcher<Plugin, PluginModel> {
    public PluginMatcher(EnforcerRuleHelper helper) {
        super(helper);
    }

    @Override
    protected PluginModel transform(Plugin mavenPlugin) {
        return new PluginModel(mavenPlugin.getGroupId(), mavenPlugin.getArtifactId(), mavenPlugin.getVersion());
    }

    @Override
    protected boolean matches(PluginModel supersetItem, PluginModel subsetItem) {
        String groupId = EnforcerRuleUtils.evaluateProperties(subsetItem.getGroupId(), this.getHelper());
        String artifactId = EnforcerRuleUtils.evaluateProperties(subsetItem.getArtifactId(), this.getHelper());
        return Objects.equals(supersetItem.getGroupId(), groupId) && Objects.equals(supersetItem.getArtifactId(), artifactId);
    }
}

