/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model.functions;

import com.github.ferstl.maven.pomenforcers.model.ArtifactModel;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class StringToArtifactTransformer
implements Function<String, ArtifactModel> {
    private static final Splitter COLON_SPLITTER = Splitter.on((String)":");
    public static final StringToArtifactTransformer INSTANCE = new StringToArtifactTransformer();

    public static Function<String, ArtifactModel> stringToArtifactModel() {
        return INSTANCE;
    }

    public ArtifactModel apply(String input) {
        ArrayList artifactElements = Lists.newArrayList((Iterable)COLON_SPLITTER.split((CharSequence)input));
        if (artifactElements.size() != 2) {
            throw new IllegalArgumentException("Cannot read POM information: " + input);
        }
        return new ArtifactModel((String)artifactElements.get(0), (String)artifactElements.get(1));
    }

    private StringToArtifactTransformer() {
    }
}

