/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.priority;

import com.github.ferstl.maven.pomenforcers.priority.PriorityOrdering;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrderingFactory;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class CompoundPriorityOrdering<T, P extends Comparable<P>, F extends PriorityOrderingFactory<P, T>>
extends Ordering<T> {
    private final Set<F> orderBy;
    private final Multimap<F, P> priorityMap;

    public static <T, P extends Comparable<P>, F extends PriorityOrderingFactory<P, T>> CompoundPriorityOrdering<T, P, F> orderBy(Iterable<F> artifactElements) {
        if (Iterables.isEmpty(artifactElements)) {
            throw new IllegalArgumentException("No order specified.");
        }
        return new CompoundPriorityOrdering<T, P, F>(artifactElements);
    }

    @SafeVarargs
    public static <T, P extends Comparable<P>, F extends PriorityOrderingFactory<P, T>> CompoundPriorityOrdering<T, P, F> orderBy(F ... artifactElements) {
        return CompoundPriorityOrdering.orderBy(Arrays.asList(artifactElements));
    }

    private CompoundPriorityOrdering(Iterable<F> artifactElements) {
        this.orderBy = Sets.newLinkedHashSet(artifactElements);
        this.priorityMap = LinkedHashMultimap.create();
    }

    public void redefineOrderBy(Iterable<F> artifactElements) {
        this.orderBy.clear();
        this.orderBy.addAll(Lists.newArrayList(artifactElements));
    }

    public void setPriorities(F artifactElement, Iterable<P> priorities) {
        this.priorityMap.putAll(artifactElement, priorities);
    }

    public Collection<F> getOrderBy() {
        return Collections.unmodifiableCollection(this.orderBy);
    }

    public Collection<P> getPriorities(F artifactElement) {
        return this.priorityMap.get(artifactElement);
    }

    public int compare(T left, T right) {
        return this.createOrdering().compare(left, right);
    }

    private Ordering<T> createOrdering() {
        ArrayList comparators = new ArrayList(this.orderBy.size());
        for (PriorityOrderingFactory artifactElement : this.orderBy) {
            PriorityOrdering comparator = artifactElement.createPriorityOrdering(this.priorityMap.get((Object)artifactElement));
            comparators.add(comparator);
        }
        return Ordering.compound(comparators);
    }
}

