/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.priority;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.Collection;

public class PriorityOrdering<P extends Comparable<? super P>, T>
extends Ordering<T> {
    private final Collection<P> priorityCollection;
    private final Equivalence<? super P> priorityMatcher;
    private final Function<T, P> transformer;

    public PriorityOrdering(Collection<P> prioritizedItems, Function<T, P> transformer, Equivalence<? super P> priorityMatcher) {
        this.priorityCollection = prioritizedItems;
        this.priorityMatcher = priorityMatcher;
        this.transformer = transformer;
    }

    public PriorityOrdering(Collection<P> priorityCollection, Function<T, P> transformer) {
        this(priorityCollection, transformer, Equivalence.equals());
    }

    public int compare(T object1, T object2) {
        int rank2;
        Comparable comparable1 = (Comparable)this.transformer.apply(object1);
        Comparable comparable2 = (Comparable)this.transformer.apply(object2);
        int rank1 = this.rank(comparable1);
        if (rank1 == (rank2 = this.rank(comparable2))) {
            return comparable1.compareTo(comparable2);
        }
        return rank1 - rank2;
    }

    private int rank(P item) {
        int i = 0;
        for (Comparable prioritizedItem : this.priorityCollection) {
            if (this.priorityMatcher.equivalent(item, (Object)prioritizedItem)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }
}

