/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Collection;

public final class CommaSeparatorUtils {
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");

    public static void splitAndAddToCollection(String commaSeparatedItems, Collection<String> collection) {
        CommaSeparatorUtils.splitAndAddToCollection(commaSeparatedItems, collection, Functions.identity());
    }

    public static <T> void splitAndAddToCollection(String commaSeparatedItems, Collection<T> collection, Function<String, T> transformer) {
        Iterable items = COMMA_SPLITTER.split((CharSequence)commaSeparatedItems);
        if (items.iterator().hasNext()) {
            collection.clear();
        }
        Iterables.addAll(collection, (Iterable)Iterables.transform((Iterable)items, transformer));
    }

    public static String join(Iterable<?> parts) {
        return COMMA_JOINER.join(parts);
    }

    public static <T> String join(Iterable<T> parts, Function<T, String> transformer) {
        Iterable convertedParts = Iterables.transform(parts, transformer);
        return COMMA_JOINER.join(convertedParts);
    }

    private CommaSeparatorUtils() {
    }
}

