/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.util;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public final class EnforcerRuleUtils {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{.*?\\}");

    public static MavenProject getMavenProject(EnforcerRuleHelper helper) {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException e) {
            throw new IllegalStateException("Unable to get maven project", e);
        }
    }

    public static String evaluateProperties(String input, EnforcerRuleHelper helper) {
        if (!Strings.isNullOrEmpty((String)input)) {
            Matcher matcher = PROPERTY_PATTERN.matcher(input);
            StringBuffer substituted = new StringBuffer();
            while (matcher.find()) {
                String property = matcher.group();
                matcher.appendReplacement(substituted, EnforcerRuleUtils.evaluateStringProperty(property, helper));
            }
            matcher.appendTail(substituted);
            return substituted.toString();
        }
        return input;
    }

    private static String evaluateStringProperty(String property, EnforcerRuleHelper helper) {
        try {
            return (String)helper.evaluate(property);
        }
        catch (ExpressionEvaluationException e) {
            throw new IllegalArgumentException("Unable to resolve property " + property);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Property " + property + " does not evaluate to a String");
        }
    }

    private EnforcerRuleUtils() {
    }
}

