/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PedanticPluginConfigurationEnforcer
extends AbstractPedanticEnforcer {
    private boolean manageVersions = true;
    private boolean manageConfigurations = true;
    private boolean manageDependencies = true;

    public void setManageVersions(boolean manageVersions) {
        this.manageVersions = manageVersions;
    }

    public void setManageConfigurations(boolean manageConfigurations) {
        this.manageConfigurations = manageConfigurations;
    }

    public void setManageDependencies(boolean manageDependencies) {
        this.manageDependencies = manageDependencies;
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.PLUGIN_CONFIGURATION;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        if (this.manageVersions) {
            this.enforceManagedVersions(report);
        }
        if (this.manageConfigurations) {
            this.enforceManagedConfiguration(report);
        }
        if (this.manageDependencies) {
            this.enforceManagedDependencies(report);
        }
    }

    private void enforceManagedVersions(ErrorReport report) {
        Collection<PluginModel> versionedPlugins = this.searchForPlugins(PluginPredicate.WITH_VERSION);
        if (!versionedPlugins.isEmpty()) {
            report.addLine("Plugin versions have to be declared in <pluginManagement>:").addLine(ErrorReport.toList(versionedPlugins));
        }
    }

    private void enforceManagedConfiguration(ErrorReport report) {
        Collection<PluginModel> configuredPlugins = this.searchForPlugins(PluginPredicate.WITH_CONFIGURATION);
        if (!configuredPlugins.isEmpty()) {
            report.addLine("Use <pluginManagement> to configure these plugins or configure them for a specific <execution>:").addLine(ErrorReport.toList(configuredPlugins));
        }
    }

    private void enforceManagedDependencies(ErrorReport report) {
        Collection<PluginModel> pluginsWithDependencies = this.searchForPlugins(PluginPredicate.WITH_DEPENDENCIES);
        if (!pluginsWithDependencies.isEmpty()) {
            report.addLine("Use <pluginManagement> to configure plugin dependencies:").addLine(ErrorReport.toList(pluginsWithDependencies));
        }
    }

    private Collection<PluginModel> searchForPlugins(Predicate<PluginModel> predicate) {
        List<PluginModel> plugins = this.getProjectModel().getPlugins();
        return plugins.stream().filter(predicate).collect(Collectors.toList());
    }

    static enum PluginPredicate implements Predicate<PluginModel>
    {
        WITH_DEPENDENCIES{

            @Override
            public boolean test(PluginModel input) {
                return !input.getDependencies().isEmpty();
            }
        }
        ,
        WITH_CONFIGURATION{

            @Override
            public boolean test(PluginModel input) {
                return input.isConfigured();
            }
        }
        ,
        WITH_VERSION{

            @Override
            public boolean test(PluginModel input) {
                return input.getVersion() != null;
            }
        };

    }
}

