/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public enum DependencyScope {
    IMPORT("import"),
    COMPILE("compile"),
    PROVIDED("provided"),
    RUNTIME("runtime"),
    SYSTEM("system"),
    TEST("test");

    private static final Map<String, DependencyScope> dependencyScopeMap;
    private final String scopeName;

    public static DependencyScope getByScopeName(String scopeName) {
        Objects.requireNonNull(scopeName, "Scope name is null.");
        DependencyScope scope = dependencyScopeMap.get(scopeName);
        if (scope == null) {
            throw new IllegalArgumentException("Dependency scope'" + scopeName + "' does not exist.");
        }
        return scope;
    }

    private DependencyScope(String name) {
        this.scopeName = name;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    static {
        dependencyScopeMap = new LinkedHashMap<String, DependencyScope>();
        for (DependencyScope scope : DependencyScope.values()) {
            dependencyScopeMap.put(scope.getScopeName(), scope);
        }
    }
}

