/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.github.ferstl.maven.pomenforcers.model.BuildModel;
import com.github.ferstl.maven.pomenforcers.model.CollectionToStringHelper;
import com.github.ferstl.maven.pomenforcers.model.DependenciesModel;
import com.github.ferstl.maven.pomenforcers.model.DependencyManagementModel;
import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="project")
public class ProjectModel {
    private static final Joiner TO_STRING_JOINER = Joiner.on((String)"\n").skipNulls();
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    public String groupId;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    public String artifactId;
    @XmlElementWrapper(namespace="http://maven.apache.org/POM/4.0.0")
    @XmlElement(name="module", namespace="http://maven.apache.org/POM/4.0.0")
    public List<String> modules;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    public DependencyManagementModel dependencyManagement;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    public DependenciesModel dependencies;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    public BuildModel build;

    public List<String> getModules() {
        return this.modules != null ? this.modules : Collections.emptyList();
    }

    public List<DependencyModel> getManagedDependencies() {
        return this.dependencyManagement != null ? this.dependencyManagement.getDependencies() : Collections.emptyList();
    }

    public List<DependencyModel> getDependencies() {
        return this.dependencies != null ? this.dependencies.getDependencies() : Collections.emptyList();
    }

    public List<PluginModel> getManagedPlugins() {
        return this.build != null ? this.build.getManagedPlugins() : Collections.emptyList();
    }

    public List<PluginModel> getPlugins() {
        return this.build != null ? this.build.getPlugins() : Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Project ").append(this.groupId).append(":").append(this.artifactId).append(" [\n");
        return TO_STRING_JOINER.appendTo(sb, (Object)CollectionToStringHelper.toString("Modules", this.modules), (Object)this.dependencyManagement, new Object[]{this.dependencies, this.build}).append("\n]").toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectModel)) {
            return false;
        }
        ProjectModel other = (ProjectModel)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.modules, other.modules) && Objects.equals(this.dependencyManagement, other.dependencyManagement) && Objects.equals(this.dependencies, other.dependencies) && Objects.equals(this.build, other.build);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.modules, this.dependencyManagement, this.dependencies, this.build);
    }
}

