/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public class PedanticModuleOrderEnforcer
extends AbstractPedanticEnforcer {
    private final Set<String> ignoredModules = Sets.newLinkedHashSet();

    public void setIgnoredModules(String ignoredModules) {
        CommaSeparatorUtils.splitAndAddToCollection(ignoredModules, this.ignoredModules);
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.MODULE_ORDER;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        MavenProject project = EnforcerRuleUtils.getMavenProject(this.getHelper());
        if (!this.isPomProject(project)) {
            return;
        }
        ArrayList<String> declaredModules = new ArrayList<String>(this.getProjectModel().getModules());
        declaredModules.removeAll(this.ignoredModules);
        Ordering moduleOrdering = Ordering.natural();
        if (!moduleOrdering.isOrdered(declaredModules)) {
            this.reportError(report, declaredModules, (Collection<String>)moduleOrdering.immutableSortedCopy(declaredModules));
        }
    }

    private boolean isPomProject(MavenProject project) {
        return "pom".equals(project.getPackaging());
    }

    private void reportError(ErrorReport report, Collection<String> declaredModules, Collection<String> orderedModules) {
        report.addLine("You have to sort your modules alphabetically:").emptyLine().addDiff(declaredModules, orderedModules, "Actual Order", "Required Order");
        if (!this.ignoredModules.isEmpty()) {
            report.emptyLine().addLine("You may place these modules anywhere in your <modules> section:").addLine(ErrorReport.toList(this.ignoredModules));
        }
    }
}

