/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.model.DependencyElement;
import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import com.github.ferstl.maven.pomenforcers.model.DependencyScope;
import com.github.ferstl.maven.pomenforcers.model.functions.DependencyMatcher;
import com.github.ferstl.maven.pomenforcers.priority.CompoundPriorityOrdering;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrderingFactory;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

abstract class AbstractPedanticDependencyOrderEnforcer
extends AbstractPedanticEnforcer {
    private final CompoundPriorityOrdering<DependencyModel, String, DependencyElement> artifactOrdering = CompoundPriorityOrdering.orderBy((PriorityOrderingFactory[])new DependencyElement[]{DependencyElement.SCOPE, DependencyElement.GROUP_ID, DependencyElement.ARTIFACT_ID});

    public AbstractPedanticDependencyOrderEnforcer(MavenProject project, ExpressionEvaluator helper) {
        super(project, helper);
        Iterable scopePriorities = EnumSet.allOf(DependencyScope.class).stream().map(DependencyScope::getScopeName).collect(Collectors.toList());
        this.artifactOrdering.setPriorities(DependencyElement.SCOPE, scopePriorities);
    }

    public void setOrderBy(String dependencyElements) {
        LinkedHashSet orderBy = new LinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(dependencyElements, orderBy, DependencyElement::getByElementName);
        this.artifactOrdering.redefineOrderBy(orderBy);
    }

    public void setGroupIdPriorities(String groupIds) {
        LinkedHashSet groupIdPriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(groupIds, groupIdPriorities);
        this.artifactOrdering.setPriorities(DependencyElement.GROUP_ID, groupIdPriorities);
    }

    public void setArtifactIdPriorities(String artifactIds) {
        LinkedHashSet artifactIdPriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(artifactIds, artifactIdPriorities);
        this.artifactOrdering.setPriorities(DependencyElement.ARTIFACT_ID, artifactIdPriorities);
    }

    public void setScopePriorities(String scopes) {
        LinkedHashSet scopePriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(scopes, scopePriorities);
        this.artifactOrdering.setPriorities(DependencyElement.SCOPE, scopePriorities);
    }

    protected abstract Collection<DependencyModel> getDeclaredDependencies();

    protected abstract Collection<Dependency> getMavenDependencies(MavenProject var1);

    protected abstract void reportError(ErrorReport var1, Collection<DependencyModel> var2, Collection<DependencyModel> var3);

    @Override
    protected final void doEnforce(ErrorReport report) {
        MavenProject mavenProject = this.getMavenProject();
        DependencyMatcher dependencyMatcher = new DependencyMatcher(this.getHelper());
        BiMap<DependencyModel, DependencyModel> matchedDependencies = dependencyMatcher.match(this.getMavenDependencies(mavenProject), this.getDeclaredDependencies());
        Set resolvedDependencies = matchedDependencies.keySet();
        if (!this.artifactOrdering.isOrdered(resolvedDependencies)) {
            this.reportError(report, resolvedDependencies, (Collection<DependencyModel>)this.artifactOrdering.immutableSortedCopy(resolvedDependencies));
        }
    }
}

