/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.ProjectModel;
import com.github.ferstl.maven.pomenforcers.util.XmlUtils;
import java.io.File;
import java.util.Objects;
import javax.xml.bind.JAXB;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.w3c.dom.Document;

public abstract class AbstractPedanticEnforcer
extends AbstractEnforcerRule {
    private final ExpressionEvaluator helper;
    private final MavenProject project;
    private Document pom;
    private ProjectModel projectModel;
    private boolean warnOnly;

    public AbstractPedanticEnforcer(MavenProject project, ExpressionEvaluator helper) {
        this.project = Objects.requireNonNull(project);
        this.helper = Objects.requireNonNull(helper);
    }

    public final void execute() throws EnforcerRuleException {
        Document pom = XmlUtils.parseXml(this.project.getFile());
        ProjectModel model = (ProjectModel)JAXB.unmarshal((File)this.project.getFile(), ProjectModel.class);
        this.initialize(pom, model);
        ErrorReport report = new ErrorReport(this.getDescription());
        this.doEnforce(report);
        if (report.hasErrors()) {
            throw new EnforcerRuleException(report.toString());
        }
    }

    void initialize(Document pom, ProjectModel projectModel) {
        this.pom = pom;
        this.projectModel = projectModel;
    }

    protected ExpressionEvaluator getHelper() {
        return this.helper;
    }

    protected MavenProject getMavenProject() {
        return this.project;
    }

    protected Document getPom() {
        return this.pom;
    }

    protected ProjectModel getProjectModel() {
        return this.projectModel;
    }

    protected abstract PedanticEnforcerRule getDescription();

    protected abstract void doEnforce(ErrorReport var1);

    protected abstract void accept(PedanticEnforcerVisitor var1);

    public EnforcerLevel getLevel() {
        return this.warnOnly ? EnforcerLevel.WARN : EnforcerLevel.ERROR;
    }

    public String getCacheId() {
        return ((Object)((Object)this)).getClass() + "-uncachable";
    }
}

