/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.priority.PriorityOrdering;
import com.github.ferstl.maven.pomenforcers.util.CommaSeparatorUtils;
import com.github.ferstl.maven.pomenforcers.util.XmlUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Named(value="dependencyElements")
public class PedanticDependencyElementEnforcer
extends AbstractPedanticEnforcer {
    private static final Set<String> DEFAULT_ORDER = Sets.newLinkedHashSet(Arrays.asList("groupId", "artifactId", "version", "classifier", "type", "scope", "systemPath", "optional", "exclusions"));
    private PriorityOrdering<String, String> elementOrdering = new PriorityOrdering(DEFAULT_ORDER, Function.identity());
    private boolean checkDependencies = true;
    private boolean checkDependencyManagement = true;

    @Inject
    public PedanticDependencyElementEnforcer(MavenProject project, ExpressionEvaluator helper) {
        super(project, helper);
    }

    public void setElementPriorities(String elements) {
        LinkedHashSet elementPriorities = Sets.newLinkedHashSet();
        CommaSeparatorUtils.splitAndAddToCollection(elements, elementPriorities);
        elementPriorities.addAll(DEFAULT_ORDER);
        this.elementOrdering = new PriorityOrdering(elementPriorities, Function.identity());
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    public void setCheckDependencyManagement(boolean checkDependencyManagement) {
        this.checkDependencyManagement = checkDependencyManagement;
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_ELEMENT;
    }

    @Override
    protected void doEnforce(ErrorReport report) {
        if (this.checkDependencyManagement) {
            this.analyzeNodes("dependencyManagement", "/project/dependencyManagement/dependencies/dependency", report);
        }
        if (this.checkDependencies) {
            this.analyzeNodes("dependencies", "/project/dependencies/dependency", report);
        }
    }

    private void analyzeNodes(String context, String rootPath, ErrorReport errorReport) {
        NodeList nodes = XmlUtils.evaluateXPathAsNodeList(rootPath, this.getPom());
        ArrayList<Map<String, String>> unorderedNodes = new ArrayList<Map<String, String>>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList nodeElements = node.getChildNodes();
            Map<String, String> elementMap = this.createElementMap(nodeElements);
            if (this.isOrdered(elementMap.keySet())) continue;
            unorderedNodes.add(elementMap);
        }
        this.report(context, errorReport, unorderedNodes);
    }

    private Map<String, String> createElementMap(NodeList elements) {
        LinkedHashMap<String, String> elementMap = new LinkedHashMap<String, String>();
        for (int j = 0; j < elements.getLength(); ++j) {
            Node element = elements.item(j);
            if (!(element instanceof Element)) continue;
            elementMap.put(element.getNodeName(), element.getTextContent());
        }
        return elementMap;
    }

    private boolean isOrdered(Collection<String> keys) {
        return this.elementOrdering.isOrdered(keys);
    }

    private void report(String context, ErrorReport errorReport, List<Map<String, String>> unorderedNodes) {
        if (unorderedNodes.isEmpty()) {
            return;
        }
        ArrayList<String> actualOrder = new ArrayList<String>();
        ArrayList<String> requiredOrder = new ArrayList<String>();
        for (Map<String, String> elements : unorderedNodes) {
            actualOrder.addAll(this.prepareForDiff(elements.keySet(), elements));
            requiredOrder.addAll(this.prepareForDiff((Collection<String>)this.elementOrdering.immutableSortedCopy(elements.keySet()), elements));
        }
        errorReport.addLine("<" + context + ">:  Dependencies have to be declared this way:");
        errorReport.emptyLine();
        errorReport.addDiff(actualOrder, requiredOrder, "Actual Order", "Required Order");
    }

    private List<String> prepareForDiff(Collection<String> keys, Map<String, String> elementContents) {
        ArrayList<String> result = new ArrayList<String>(keys.size());
        result.add("<dependency>");
        for (String key : keys) {
            result.add("  <" + key + ">" + elementContents.get(key) + "</" + key + ">");
        }
        result.add("</dependency>");
        result.add("");
        return result;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }
}

